/*
 * Decompiled with CFR 0.152.
 */
package org.ict4h.atomfeed.client.repository.jdbc;

import java.net.URI;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.ict4h.atomfeed.Configuration;
import org.ict4h.atomfeed.client.domain.Marker;
import org.ict4h.atomfeed.client.exceptions.AtomFeedClientException;
import org.ict4h.atomfeed.client.repository.AllMarkers;
import org.ict4h.atomfeed.jdbc.JdbcConnectionProvider;
import org.ict4h.atomfeed.jdbc.JdbcUtils;

public class AllMarkersJdbcImpl
implements AllMarkers {
    private static Logger logger = Logger.getLogger(AllMarkersJdbcImpl.class);
    private JdbcConnectionProvider connectionProvider;

    public AllMarkersJdbcImpl(JdbcConnectionProvider connectionProvider) {
        this.connectionProvider = connectionProvider;
    }

    @Override
    public Marker get(URI feedUri) {
        PreparedStatement stmt = null;
        ResultSet resultSet = null;
        try {
            Connection connection = this.connectionProvider.getConnection();
            String sql = String.format("select feed_uri, last_read_entry_id, feed_uri_for_last_read_entry from %s where feed_uri = ?", JdbcUtils.getTableName((String)Configuration.getInstance().getSchema(), (String)"markers"));
            stmt = connection.prepareStatement(sql);
            stmt.setString(1, feedUri.toString());
            resultSet = stmt.executeQuery();
            List<Marker> markers = this.mapMarkersFromResultSet(resultSet);
            if (markers != null && !markers.isEmpty()) {
                Marker marker = markers.get(0);
                logger.info((Object)String.format("Found marker: %s", marker.toString()));
                Marker marker2 = marker;
                this.closeAll(stmt, resultSet);
                return marker2;
            }
            this.closeAll(stmt, resultSet);
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                this.closeAll(stmt, resultSet);
                throw throwable;
            }
        }
        return null;
    }

    private List<Marker> mapMarkersFromResultSet(ResultSet resultSet) {
        ArrayList<Marker> markers = new ArrayList<Marker>();
        try {
            while (resultSet.next()) {
                Marker marker = new Marker(new URI(resultSet.getString(1)), resultSet.getString(2), new URI(resultSet.getString(3)));
                markers.add(marker);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed while mapping markers from database", e);
        }
        return markers;
    }

    @Override
    public void put(URI feedUri, String entryId, URI entryFeedUri) {
        Marker existingMarker = this.get(feedUri);
        if (existingMarker != null) {
            this.updateMarker(feedUri, entryId, entryFeedUri);
            return;
        }
        this.insertMarker(feedUri, entryId, entryFeedUri);
    }

    private void updateMarker(URI feedUri, String entryId, URI entryFeedUri) {
        String sql = String.format("update %s set last_read_entry_id = ?, feed_uri_for_last_read_entry = ? where feed_uri = ?", JdbcUtils.getTableName((String)Configuration.getInstance().getSchema(), (String)"markers"));
        PreparedStatement statement = null;
        try {
            Connection connection = this.connectionProvider.getConnection();
            statement = connection.prepareStatement(sql);
            statement.setString(1, entryId);
            statement.setString(2, entryFeedUri.toString());
            statement.setString(3, feedUri.toString());
            statement.executeUpdate();
            logger.info((Object)String.format("Updated marker: %s", new Marker(feedUri, entryId, entryFeedUri).toString()));
            this.closeAll(statement, null);
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                this.closeAll(statement, null);
                throw throwable;
            }
        }
    }

    private void insertMarker(URI feedUri, String entryId, URI entryFeedUri) {
        String sql = String.format("insert into %s (feed_uri, last_read_entry_id, feed_uri_for_last_read_entry) values (?, ?, ?)", JdbcUtils.getTableName((String)Configuration.getInstance().getSchema(), (String)"markers"));
        PreparedStatement statement = null;
        try {
            Connection connection = this.connectionProvider.getConnection();
            statement = connection.prepareStatement(sql);
            statement.setString(1, feedUri.toString());
            statement.setString(2, entryId);
            statement.setString(3, entryFeedUri.toString());
            statement.executeUpdate();
            logger.info((Object)String.format("Created marker: %s", new Marker(feedUri, entryId, entryFeedUri).toString()));
            this.closeAll(statement, null);
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                this.closeAll(statement, null);
                throw throwable;
            }
        }
    }

    private void closeAll(PreparedStatement stmt, ResultSet rs) {
        try {
            if (rs != null) {
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (SQLException e) {
            throw new AtomFeedClientException(e);
        }
    }
}

