/*
 * Decompiled with CFR 0.152.
 */
package org.ict4h.atomfeed.client.service;

import com.sun.syndication.feed.atom.Entry;
import com.sun.syndication.feed.atom.Feed;
import java.net.URI;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import org.ict4h.atomfeed.client.AtomFeedProperties;
import org.ict4h.atomfeed.client.domain.Event;
import org.ict4h.atomfeed.client.domain.FailedEvent;
import org.ict4h.atomfeed.client.domain.Marker;
import org.ict4h.atomfeed.client.exceptions.AtomFeedClientException;
import org.ict4h.atomfeed.client.repository.AllFailedEvents;
import org.ict4h.atomfeed.client.repository.AllFeeds;
import org.ict4h.atomfeed.client.repository.AllMarkers;
import org.ict4h.atomfeed.client.service.EventWorker;
import org.ict4h.atomfeed.client.service.FeedClient;
import org.ict4h.atomfeed.client.service.FeedEnumerator;
import org.ict4h.atomfeed.client.util.Util;
import org.ict4h.atomfeed.transaction.AFTransactionManager;
import org.ict4h.atomfeed.transaction.AFTransactionWork;
import org.ict4h.atomfeed.transaction.AFTransactionWorkWithoutResult;

public class AtomFeedClient
implements FeedClient {
    private static final int FAILED_EVENTS_PROCESS_BATCH_SIZE = 5;
    private static Logger logger = Logger.getLogger(AtomFeedClient.class);
    private AllFeeds allFeeds;
    private AtomFeedProperties atomFeedProperties;
    private AFTransactionManager transactionManager;
    private URI feedUri;
    private EventWorker eventWorker;
    private AllMarkers allMarkers;
    private AllFailedEvents allFailedEvents;

    AtomFeedClient(AllFeeds allFeeds, AllMarkers allMarkers, AllFailedEvents allFailedEvents, URI feedUri, EventWorker eventWorker) {
        this(allFeeds, allMarkers, allFailedEvents, new AtomFeedProperties(), null, feedUri, eventWorker);
    }

    public AtomFeedClient(AllFeeds allFeeds, AllMarkers allMarkers, AllFailedEvents allFailedEvents, AtomFeedProperties atomFeedProperties, AFTransactionManager transactionManager, URI feedUri, EventWorker eventWorker) {
        this.allFeeds = allFeeds;
        this.allMarkers = allMarkers;
        this.allFailedEvents = allFailedEvents;
        this.atomFeedProperties = atomFeedProperties;
        this.transactionManager = transactionManager;
        this.feedUri = feedUri;
        this.eventWorker = eventWorker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void processEvents() {
        logger.info((Object)String.format("Processing events for feed URI : %s using event worker : %s", this.feedUri, this.eventWorker.getClass().getSimpleName()));
        try {
            Marker lastRead = (Marker)this.transactionManager.executeWithTransaction((AFTransactionWork)new MarkerReader(this.feedUri));
            FeedEnumerator enumerator = new FeedEnumerator(this.allFeeds, lastRead);
            for (Entry entry : enumerator) {
                Integer numberOfFailedEvents = (Integer)this.transactionManager.executeWithTransaction((AFTransactionWork)new FailedEventCounter(this.feedUri));
                if (numberOfFailedEvents >= this.atomFeedProperties.getMaxFailedEvents()) {
                    logger.error((Object)String.format("Too many failed events for URI:%s have failed while processing. Cannot continue.", this.feedUri));
                    return;
                }
                Event eventInProcess = null;
                try {
                    eventInProcess = new Event(entry, this.getEntryFeedUri(enumerator));
                    logger.info((Object)String.format("Processing event : %s", eventInProcess));
                    this.transactionManager.executeWithTransaction((AFTransactionWork)new EventProcessor(eventInProcess, enumerator.getCurrentFeed()));
                    this.eventWorker.cleanUp(eventInProcess);
                }
                catch (Exception eventProcessingException) {
                    try {
                        logger.error((Object)String.format("Error occurred while processing feed entry:%s", entry), (Throwable)eventProcessingException);
                        try {
                            this.transactionManager.executeWithTransaction((AFTransactionWork)new FailedEventHandler(this.feedUri, entry, eventInProcess, enumerator.getCurrentFeed(), eventProcessingException));
                        }
                        catch (Exception feEx) {
                            String errorMsg = String.format("Error occurred while trying to save event as Failed: %s", eventInProcess);
                            logger.error((Object)errorMsg, (Throwable)feEx);
                            throw new RuntimeException(errorMsg, feEx);
                        }
                        this.eventWorker.cleanUp(eventInProcess);
                    }
                    catch (Throwable throwable) {
                        this.eventWorker.cleanUp(eventInProcess);
                        throw throwable;
                        return;
                    }
                }
            }
        }
        catch (Exception e) {
            throw new AtomFeedClientException(e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void processFailedEvents() {
        logger.info((Object)String.format("Processing failed events for feed URI : %s using event worker : %s", this.feedUri, this.eventWorker.getClass().getSimpleName()));
        try {
            List failedEvents = (List)this.transactionManager.executeWithTransaction((AFTransactionWork)new FailedEventsFetcher());
            for (FailedEvent failedEvent : failedEvents) {
                try {
                    logger.info((Object)String.format("Processing previously failed event : %s", failedEvent));
                    this.transactionManager.executeWithTransaction((AFTransactionWork)new FailedEventProcessor(failedEvent));
                }
                catch (Exception retryException) {
                    logger.error((Object)String.format("Failed to process failed event. %s", failedEvent), (Throwable)retryException);
                    try {
                        this.transactionManager.executeWithTransaction((AFTransactionWork)new EventRetryFailureHandler(failedEvent, retryException));
                    }
                    catch (Exception fePEx) {
                        String errorMsg = String.format("Error occurred while trying to update failed event. %s", failedEvent);
                        logger.error((Object)errorMsg, (Throwable)fePEx);
                        throw new RuntimeException(errorMsg, fePEx);
                        return;
                    }
                }
            }
        }
        catch (Exception e) {
            throw new AtomFeedClientException(e);
        }
    }

    private void updateFailedEvents(FailedEvent failedEvent, Exception e) {
        failedEvent.setFailedAt(new Date().getTime());
        failedEvent.setErrorMessage(Util.getExceptionString(e));
        this.allFailedEvents.addOrUpdate(failedEvent);
    }

    private String getEntryFeedUri(FeedEnumerator feedEnumerator) {
        return Util.getSelfLink(feedEnumerator.getCurrentFeed()).toString();
    }

    private void handleFailedEvent(Entry entry, URI feedUri, Exception e, Feed feed, Event event) {
        this.allFailedEvents.addOrUpdate(new FailedEvent(feedUri.toString(), event, Util.getExceptionString(e)));
        if (this.atomFeedProperties.controlsEventProcessing()) {
            this.allMarkers.put(this.feedUri, entry.getId(), Util.getViaLink(feed));
        }
    }

    private class FailedEventsFetcher
    implements AFTransactionWork<List<FailedEvent>> {
        private FailedEventsFetcher() {
        }

        public List<FailedEvent> execute() {
            return AtomFeedClient.this.allFailedEvents.getOldestNFailedEvents(AtomFeedClient.this.feedUri.toString(), 5);
        }

        public AFTransactionWork.PropagationDefinition getTxPropagationDefinition() {
            return AFTransactionWork.PropagationDefinition.PROPAGATION_REQUIRED;
        }
    }

    private class FailedEventProcessor
    extends AFTransactionWorkWithoutResult {
        private final FailedEvent eventInProcess;

        public FailedEventProcessor(FailedEvent failedEvent) {
            this.eventInProcess = failedEvent;
        }

        public AFTransactionWork.PropagationDefinition getTxPropagationDefinition() {
            return AFTransactionWork.PropagationDefinition.PROPAGATION_REQUIRES_NEW;
        }

        protected void doInTransaction() {
            logger.debug((Object)String.format("Processing failed event : %s", this.eventInProcess));
            AtomFeedClient.this.eventWorker.process(this.eventInProcess.getEvent());
            AtomFeedClient.this.allFailedEvents.remove(this.eventInProcess);
        }
    }

    private class EventRetryFailureHandler
    extends AFTransactionWorkWithoutResult {
        private FailedEvent failedEvent;
        private Exception failureException;

        public EventRetryFailureHandler(FailedEvent failedEvent, Exception failureException) {
            this.failedEvent = failedEvent;
            this.failureException = failureException;
        }

        public AFTransactionWork.PropagationDefinition getTxPropagationDefinition() {
            return AFTransactionWork.PropagationDefinition.PROPAGATION_REQUIRES_NEW;
        }

        protected void doInTransaction() {
            AtomFeedClient.this.updateFailedEvents(this.failedEvent, this.failureException);
        }
    }

    private class FailedEventHandler
    extends AFTransactionWorkWithoutResult {
        private URI feedURI;
        private Entry failedEntry;
        private Event failedEvent;
        private Feed workingFeed;
        private Exception failureException;

        public FailedEventHandler(URI feedURI, Entry failedEntry, Event failedEvent, Feed workingFeed, Exception failureException) {
            this.feedURI = feedURI;
            this.failedEntry = failedEntry;
            this.failedEvent = failedEvent;
            this.workingFeed = workingFeed;
            this.failureException = failureException;
        }

        protected void doInTransaction() {
            AtomFeedClient.this.handleFailedEvent(this.failedEntry, this.feedURI, this.failureException, this.workingFeed, this.failedEvent);
        }

        public AFTransactionWork.PropagationDefinition getTxPropagationDefinition() {
            return AFTransactionWork.PropagationDefinition.PROPAGATION_REQUIRES_NEW;
        }
    }

    public class MarkerReader
    implements AFTransactionWork<Marker> {
        private URI feedUri;

        public MarkerReader(URI feedUri) {
            this.feedUri = feedUri;
        }

        public Marker execute() {
            Marker lastRead = AtomFeedClient.this.allMarkers.get(this.feedUri);
            if (lastRead == null) {
                lastRead = new Marker(this.feedUri, null, null);
            }
            return lastRead;
        }

        public AFTransactionWork.PropagationDefinition getTxPropagationDefinition() {
            return AFTransactionWork.PropagationDefinition.PROPAGATION_REQUIRED;
        }
    }

    private class EventProcessor
    extends AFTransactionWorkWithoutResult {
        private Event eventInProcess;
        private Feed currentFeed;

        public EventProcessor(Event eventInProcess, Feed currentFeed) {
            this.eventInProcess = eventInProcess;
            this.currentFeed = currentFeed;
        }

        protected void doInTransaction() {
            logger.debug((Object)("Processing event : " + this.eventInProcess));
            AtomFeedClient.this.eventWorker.process(this.eventInProcess);
            if (AtomFeedClient.this.atomFeedProperties.controlsEventProcessing()) {
                AtomFeedClient.this.allMarkers.put(AtomFeedClient.this.feedUri, this.eventInProcess.getId(), Util.getViaLink(this.currentFeed));
            }
        }

        public AFTransactionWork.PropagationDefinition getTxPropagationDefinition() {
            return AFTransactionWork.PropagationDefinition.PROPAGATION_REQUIRES_NEW;
        }
    }

    private class FailedEventCounter
    implements AFTransactionWork<Integer> {
        private URI feedURI;

        public FailedEventCounter(URI feedURI) {
            this.feedURI = feedURI;
        }

        public Integer execute() {
            return AtomFeedClient.this.allFailedEvents.getNumberOfFailedEvents(this.feedURI.toString());
        }

        public AFTransactionWork.PropagationDefinition getTxPropagationDefinition() {
            return AFTransactionWork.PropagationDefinition.PROPAGATION_REQUIRED;
        }
    }
}

