/*
 * Decompiled with CFR 0.152.
 */
package org.ict4h.atomfeed.client.repository.memory;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.ict4h.atomfeed.client.domain.FailedEvent;
import org.ict4h.atomfeed.client.repository.AllFailedEvents;

public class AllFailedEventsInMemoryImpl
implements AllFailedEvents {
    private List<FailedEvent> failedEvents = Collections.synchronizedList(new ArrayList());

    @Override
    public FailedEvent get(String feedUri, String id) {
        for (FailedEvent failedEvent : this.failedEvents) {
            if (!failedEvent.getFeedUri().equalsIgnoreCase(feedUri) || !failedEvent.getEventId().equals(id)) continue;
            return failedEvent;
        }
        return null;
    }

    @Override
    public void addOrUpdate(FailedEvent failedEvent) {
        boolean modified = false;
        for (int i = 0; i < this.failedEvents.size(); ++i) {
            if (!failedEvent.getEventId().equals(this.failedEvents.get(i).getEventId())) continue;
            modified = true;
            this.failedEvents.set(i, failedEvent);
            break;
        }
        if (modified) {
            this.failedEvents.add(failedEvent);
        }
    }

    @Override
    public List<FailedEvent> getOldestNFailedEvents(String feedUri, int numberOfFailedEvents) {
        if (numberOfFailedEvents < 1) {
            throw new IllegalArgumentException("Number of failed events should at least be one.");
        }
        ArrayList<FailedEvent> lastNFailedEvents = new ArrayList<FailedEvent>();
        for (int i = this.failedEvents.size() - 1; i >= 0 && lastNFailedEvents.size() != numberOfFailedEvents; --i) {
            FailedEvent failedEvent = this.failedEvents.get(i);
            if (!failedEvent.getFeedUri().toString().equalsIgnoreCase(feedUri)) continue;
            lastNFailedEvents.add(failedEvent);
        }
        return lastNFailedEvents;
    }

    public List<FailedEvent> getAllFailedEvents(String feedUri) {
        ArrayList<FailedEvent> allFailedEvents = new ArrayList<FailedEvent>();
        for (int i = this.failedEvents.size() - 1; i >= 0; --i) {
            FailedEvent failedEvent = this.failedEvents.get(i);
            if (!failedEvent.getFeedUri().toString().equalsIgnoreCase(feedUri)) continue;
            allFailedEvents.add(failedEvent);
        }
        return allFailedEvents;
    }

    @Override
    public int getNumberOfFailedEvents(String feedUri) {
        int numberOfFailedEvents = 0;
        for (int i = this.failedEvents.size() - 1; i >= 0; --i) {
            if (!this.failedEvents.get(i).getFeedUri().toString().equalsIgnoreCase(feedUri)) continue;
            ++numberOfFailedEvents;
        }
        return numberOfFailedEvents;
    }

    @Override
    public void remove(FailedEvent failedEvent) {
        for (int i = 0; i < this.failedEvents.size(); ++i) {
            if (!failedEvent.getEventId().equals(this.failedEvents.get(i).getEventId())) continue;
            this.failedEvents.remove(i);
            break;
        }
    }
}

