/*
 * Decompiled with CFR 0.152.
 */
package org.ict4h.atomfeed.client.repository.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.ict4h.atomfeed.Configuration;
import org.ict4h.atomfeed.client.domain.Event;
import org.ict4h.atomfeed.client.domain.FailedEvent;
import org.ict4h.atomfeed.client.exceptions.AtomFeedClientException;
import org.ict4h.atomfeed.client.repository.AllFailedEvents;
import org.ict4h.atomfeed.jdbc.JdbcConnectionProvider;
import org.ict4h.atomfeed.jdbc.JdbcUtils;

public class AllFailedEventsJdbcImpl
implements AllFailedEvents {
    private static Logger logger = Logger.getLogger(AllFailedEventsJdbcImpl.class);
    public static final String FAILED_EVENTS_TABLE = "failed_events";
    public static final int ERROR_MSG_MAX_LEN = 4000;
    private JdbcConnectionProvider connectionProvider;

    public AllFailedEventsJdbcImpl(JdbcConnectionProvider connectionProvider) {
        this.connectionProvider = connectionProvider;
    }

    @Override
    public FailedEvent get(String feedUri, String eventId) {
        ResultSet resultSet;
        PreparedStatement statement;
        block5: {
            statement = null;
            resultSet = null;
            Connection connection = this.connectionProvider.getConnection();
            String sql = String.format("select id, feed_uri, failed_at, error_message, event_id, event_content, title from %s where feed_uri = ? and event_id = ?", JdbcUtils.getTableName((String)Configuration.getInstance().getSchema(), (String)FAILED_EVENTS_TABLE));
            statement = connection.prepareStatement(sql);
            statement.setString(1, feedUri);
            statement.setString(2, eventId);
            resultSet = statement.executeQuery();
            List<FailedEvent> failedEvents = this.mapFailedEventsFromResultSet(resultSet);
            if (failedEvents == null || failedEvents.isEmpty()) break block5;
            FailedEvent failedEvent = failedEvents.get(0);
            this.closeAll(statement, resultSet);
            return failedEvent;
        }
        try {
            logger.info((Object)String.format("Reading failed event - feedUri=%s, eventId=%s", feedUri, eventId));
            this.closeAll(statement, resultSet);
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                this.closeAll(statement, resultSet);
                throw throwable;
            }
        }
        return null;
    }

    private void closeAll(PreparedStatement stmt, ResultSet rs) {
        try {
            if (rs != null) {
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (SQLException e) {
            throw new AtomFeedClientException(e);
        }
    }

    private List<FailedEvent> mapFailedEventsFromResultSet(ResultSet resultSet) {
        ArrayList<FailedEvent> failedEvents = new ArrayList<FailedEvent>();
        try {
            while (resultSet.next()) {
                Event event = new Event(resultSet.getString(5), resultSet.getString(6), resultSet.getString(7));
                FailedEvent failedEvent = new FailedEvent(resultSet.getString(2), event, resultSet.getString(4), resultSet.getTimestamp(3).getTime());
                failedEvents.add(failedEvent);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed while mapping failedEvents from database", e);
        }
        return failedEvents;
    }

    @Override
    public void addOrUpdate(FailedEvent failedEvent) {
        FailedEvent existingFailedEvent = this.get(failedEvent.getFeedUri(), failedEvent.getEventId());
        if (existingFailedEvent != null) {
            this.updateFailedEvent(failedEvent);
            return;
        }
        this.insertFailedEvent(failedEvent);
    }

    private void insertFailedEvent(FailedEvent failedEvent) {
        String sql = String.format("insert into %s (feed_uri, failed_at, error_message, event_id, event_content, error_hash_code, title) values (?, ?, ?, ?, ?, ?, ?)", JdbcUtils.getTableName((String)Configuration.getInstance().getSchema(), (String)FAILED_EVENTS_TABLE));
        String errorMessage = failedEvent.getErrorMessage().length() > 4000 ? failedEvent.getErrorMessage().substring(0, 4000) : failedEvent.getErrorMessage();
        PreparedStatement statement = null;
        try {
            Connection connection = this.connectionProvider.getConnection();
            statement = connection.prepareStatement(sql);
            statement.setString(1, failedEvent.getFeedUri());
            statement.setTimestamp(2, new Timestamp(failedEvent.getFailedAt()));
            statement.setString(3, errorMessage);
            statement.setString(4, failedEvent.getEventId());
            statement.setString(5, failedEvent.getEvent().getContent());
            statement.setInt(6, errorMessage.hashCode());
            statement.setString(7, failedEvent.getEvent().getTitle());
            statement.executeUpdate();
            logger.info((Object)String.format("Created a new %s", failedEvent.toString()));
            this.closeAll(statement, null);
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                this.closeAll(statement, null);
                throw throwable;
            }
        }
    }

    private void updateFailedEvent(FailedEvent failedEvent) {
        String sql = String.format("update %s set failed_at = ?, error_message = ?, event_content = ?, error_hash_code = ?, title = ? where feed_uri = ? and event_id = ?", JdbcUtils.getTableName((String)Configuration.getInstance().getSchema(), (String)FAILED_EVENTS_TABLE));
        String errorMessage = failedEvent.getErrorMessage().length() > 4000 ? failedEvent.getErrorMessage().substring(0, 4000) : failedEvent.getErrorMessage();
        PreparedStatement statement = null;
        try {
            Connection connection = this.connectionProvider.getConnection();
            statement = connection.prepareStatement(sql);
            statement.setTimestamp(1, new Timestamp(failedEvent.getFailedAt()));
            statement.setString(2, errorMessage);
            statement.setString(3, failedEvent.getEvent().getContent());
            statement.setLong(4, errorMessage.hashCode());
            statement.setString(5, failedEvent.getEvent().getTitle());
            statement.setString(6, failedEvent.getFeedUri());
            statement.setString(7, failedEvent.getEventId());
            statement.executeUpdate();
            logger.info((Object)String.format("Updated %s", failedEvent.toString()));
            this.closeAll(statement, null);
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                this.closeAll(statement, null);
                throw throwable;
            }
        }
    }

    @Override
    public List<FailedEvent> getOldestNFailedEvents(String feedUri, int numberOfFailedEvents) {
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            Connection connection = this.connectionProvider.getConnection();
            String sql = String.format("select id, feed_uri, failed_at, error_message, event_id, event_content, title from %s where feed_uri = ? order by id", JdbcUtils.getTableName((String)Configuration.getInstance().getSchema(), (String)FAILED_EVENTS_TABLE));
            statement = connection.prepareStatement(sql);
            statement.setString(1, feedUri);
            statement.setMaxRows(numberOfFailedEvents);
            resultSet = statement.executeQuery();
            List<FailedEvent> failedEvents = this.mapFailedEventsFromResultSet(resultSet);
            logger.info((Object)String.format("Loaded %d failed events for %s", failedEvents.size(), feedUri));
            List<FailedEvent> list = failedEvents;
            this.closeAll(statement, resultSet);
            return list;
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                this.closeAll(statement, resultSet);
                throw throwable;
            }
        }
    }

    @Override
    public int getNumberOfFailedEvents(String feedUri) {
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            Connection connection = this.connectionProvider.getConnection();
            statement = connection.prepareStatement(String.format("select count(*) from %s", JdbcUtils.getTableName((String)Configuration.getInstance().getSchema(), (String)FAILED_EVENTS_TABLE)));
            resultSet = statement.executeQuery();
            int numberOfFailedEvents = resultSet.next() ? resultSet.getInt(1) : 0;
            logger.info((Object)String.format("There are %d failed events for %s", numberOfFailedEvents, feedUri));
            int n = numberOfFailedEvents;
            this.closeAll(statement, resultSet);
            return n;
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                this.closeAll(statement, resultSet);
                throw throwable;
            }
        }
    }

    @Override
    public void remove(FailedEvent failedEvent) {
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            Connection connection = this.connectionProvider.getConnection();
            statement = connection.prepareStatement(String.format("delete from %s where feed_uri = ? and event_id = ?", JdbcUtils.getTableName((String)Configuration.getInstance().getSchema(), (String)FAILED_EVENTS_TABLE)));
            statement.setString(1, failedEvent.getFeedUri());
            statement.setString(2, failedEvent.getEventId());
            statement.executeUpdate();
            logger.info((Object)String.format("Deleted %s", failedEvent.toString()));
            this.closeAll(statement, resultSet);
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                this.closeAll(statement, resultSet);
                throw throwable;
            }
        }
    }
}

