/*
 * Decompiled with CFR 0.152.
 */
package org.ict4h.atomfeed.client.domain;

import java.util.Date;
import org.ict4h.atomfeed.client.domain.Event;

public class FailedEvent {
    private long failedAt;
    private Event event;
    private String errorMessage;
    private String feedUri;

    public FailedEvent(String feedUri, Event event, String errorMessage) {
        if (feedUri == null || feedUri.trim().equals("") || event == null) {
            throw new IllegalArgumentException("Arguments provided should not be null.");
        }
        this.event = event;
        this.errorMessage = errorMessage;
        this.feedUri = feedUri;
        this.failedAt = new Date().getTime();
    }

    public FailedEvent(String feedUri, Event event, String errorMessage, long failedAt) {
        this(feedUri, event, errorMessage);
        this.failedAt = failedAt;
    }

    public long getFailedAt() {
        return this.failedAt;
    }

    public Event getEvent() {
        return this.event;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getFeedUri() {
        return this.feedUri;
    }

    public String getEventId() {
        return this.event.getId();
    }

    public void setFailedAt(long failedAt) {
        this.failedAt = failedAt;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public String toString() {
        return String.format("FailedEvent{failedAt=%d, event=%s, errorMessage='%s', feedUri='%s'}", this.failedAt, this.event, this.errorMessage, this.feedUri);
    }
}

