/*
 * Decompiled with CFR 0.152.
 */
package org.ict4h.atomfeed.client.service;

import com.sun.syndication.feed.atom.Entry;
import com.sun.syndication.feed.atom.Feed;
import java.net.URI;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.ict4h.atomfeed.client.domain.Event;
import org.ict4h.atomfeed.client.domain.FailedEvent;
import org.ict4h.atomfeed.client.domain.Marker;
import org.ict4h.atomfeed.client.exceptions.AtomFeedClientException;
import org.ict4h.atomfeed.client.factory.AtomFeedProperties;
import org.ict4h.atomfeed.client.repository.AllFailedEvents;
import org.ict4h.atomfeed.client.repository.AllFeeds;
import org.ict4h.atomfeed.client.repository.AllMarkers;
import org.ict4h.atomfeed.client.service.EventWorker;
import org.ict4h.atomfeed.client.service.FeedClient;
import org.ict4h.atomfeed.client.service.FeedEnumerator;
import org.ict4h.atomfeed.client.util.Util;
import org.ict4h.atomfeed.jdbc.JdbcConnectionProvider;

public class AtomFeedClient
implements FeedClient {
    private static final int FAILED_EVENTS_PROCESS_BATCH_SIZE = 5;
    private static Logger logger = Logger.getLogger(AtomFeedClient.class);
    private AllFeeds allFeeds;
    private AtomFeedProperties atomFeedProperties;
    private JdbcConnectionProvider jdbcConnectionProvider;
    private URI feedUri;
    private EventWorker eventWorker;
    private Map<String, String> cookies;
    private AllMarkers allMarkers;
    private AllFailedEvents allFailedEvents;

    AtomFeedClient(AllFeeds allFeeds, AllMarkers allMarkers, AllFailedEvents allFailedEvents, URI feedUri, EventWorker eventWorker) {
        this(allFeeds, allMarkers, allFailedEvents, new AtomFeedProperties(), null, feedUri, eventWorker);
    }

    public AtomFeedClient(AllFeeds allFeeds, AllMarkers allMarkers, AllFailedEvents allFailedEvents, AtomFeedProperties atomFeedProperties, JdbcConnectionProvider jdbcConnectionProvider, URI feedUri, EventWorker eventWorker) {
        this.allFeeds = allFeeds;
        this.allMarkers = allMarkers;
        this.allFailedEvents = allFailedEvents;
        this.atomFeedProperties = atomFeedProperties;
        this.jdbcConnectionProvider = jdbcConnectionProvider;
        this.feedUri = feedUri;
        this.eventWorker = eventWorker;
        this.cookies = this.cookies;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void processEvents() {
        logger.info((Object)String.format("Processing events for feed URI : %s using event worker : %s", this.feedUri, this.eventWorker.getClass().getSimpleName()));
        Connection connection = null;
        boolean autoCommit = false;
        try {
            Marker marker;
            connection = this.jdbcConnectionProvider.getConnection();
            autoCommit = connection.getAutoCommit();
            if (this.atomFeedProperties.controlsEventProcessing()) {
                connection.setAutoCommit(false);
            }
            if ((marker = this.allMarkers.get(this.feedUri)) == null) {
                marker = new Marker(this.feedUri, null, null);
            }
            FeedEnumerator feedEnumerator = new FeedEnumerator(this.allFeeds, marker);
            Event event = null;
            for (Entry entry : feedEnumerator) {
                if (this.shouldNotProcessEvents(this.feedUri)) {
                    logger.warn((Object)"Too many failed events have failed while processing. Cannot continue.");
                    return;
                }
                try {
                    event = new Event(entry, this.getEntryFeedUri(feedEnumerator));
                    logger.debug((Object)("Processing event : " + event));
                    this.eventWorker.process(event);
                    if (this.atomFeedProperties.controlsEventProcessing()) {
                        this.allMarkers.put(this.feedUri, entry.getId(), Util.getViaLink(feedEnumerator.getCurrentFeed()));
                        connection.commit();
                    }
                    this.eventWorker.cleanUp(event);
                }
                catch (Exception e) {
                    try {
                        logger.error((Object)"", (Throwable)e);
                        if (this.atomFeedProperties.controlsEventProcessing()) {
                            connection.rollback();
                        }
                        this.handleFailedEvent(entry, this.feedUri, e, feedEnumerator.getCurrentFeed(), event);
                        if (this.atomFeedProperties.controlsEventProcessing()) {
                            connection.commit();
                        }
                        this.eventWorker.cleanUp(event);
                    }
                    catch (Throwable throwable) {
                        this.eventWorker.cleanUp(event);
                        throw throwable;
                        return;
                    }
                }
            }
        }
        catch (SQLException e) {
            throw new AtomFeedClientException(e);
        }
        finally {
            if (connection != null) {
                try {
                    if (this.atomFeedProperties.controlsEventProcessing()) {
                        connection.setAutoCommit(autoCommit);
                    }
                    connection.close();
                }
                catch (SQLException e) {
                    throw new AtomFeedClientException(e);
                }
            }
        }
    }

    @Override
    public void processFailedEvents() {
        logger.info((Object)String.format("Processing failed events for feed URI : %s using event worker : %s", this.feedUri, this.eventWorker.getClass().getSimpleName()));
        Connection connection = null;
        boolean autoCommit = false;
        try {
            connection = this.jdbcConnectionProvider.getConnection();
            autoCommit = connection.getAutoCommit();
            if (this.atomFeedProperties.controlsEventProcessing()) {
                connection.setAutoCommit(false);
            }
            List<FailedEvent> failedEvents = this.allFailedEvents.getOldestNFailedEvents(this.feedUri.toString(), 5);
            for (FailedEvent failedEvent : failedEvents) {
                try {
                    logger.debug((Object)String.format("Processing failed event : %s", failedEvent));
                    this.eventWorker.process(failedEvent.getEvent());
                    if (!this.atomFeedProperties.controlsEventProcessing()) continue;
                    this.allFailedEvents.remove(failedEvent);
                    connection.commit();
                }
                catch (Exception e) {
                    logger.error((Object)"", (Throwable)e);
                    if (this.atomFeedProperties.controlsEventProcessing()) {
                        connection.rollback();
                        failedEvent.setFailedAt(new Date().getTime());
                        failedEvent.setErrorMessage(Util.getExceptionString(e));
                        this.allFailedEvents.addOrUpdate(failedEvent);
                        connection.commit();
                    }
                    logger.info((Object)String.format("Failed to process failed event. %s", failedEvent));
                }
            }
        }
        catch (SQLException e) {
            throw new AtomFeedClientException(e);
        }
        finally {
            if (connection != null) {
                try {
                    if (this.atomFeedProperties.controlsEventProcessing()) {
                        connection.setAutoCommit(autoCommit);
                    }
                    connection.close();
                }
                catch (SQLException e) {
                    throw new AtomFeedClientException(e);
                }
            }
        }
    }

    private String getEntryFeedUri(FeedEnumerator feedEnumerator) {
        return Util.getSelfLink(feedEnumerator.getCurrentFeed()).toString();
    }

    private boolean shouldNotProcessEvents(URI feedUri) {
        return this.allFailedEvents.getNumberOfFailedEvents(feedUri.toString()) >= this.atomFeedProperties.getMaxFailedEvents();
    }

    private void handleFailedEvent(Entry entry, URI feedUri, Exception e, Feed feed, Event event) {
        this.allFailedEvents.addOrUpdate(new FailedEvent(feedUri.toString(), event, Util.getExceptionString(e)));
        if (this.atomFeedProperties.controlsEventProcessing()) {
            this.allMarkers.put(this.feedUri, entry.getId(), Util.getViaLink(feed));
        }
    }
}

