/*
 * Decompiled with CFR 0.152.
 */
package org.ict4h.atomfeed.client.domain;

import com.sun.syndication.feed.atom.Content;
import com.sun.syndication.feed.atom.Entry;

public class Event {
    private String id;
    private String content;
    private String feedUri;

    public Event(Entry entry) {
        this.id = entry.getId();
        this.content = this.extractContent(entry);
    }

    public Event(String id, String content) {
        this.id = id;
        this.content = content;
    }

    public Event(Entry entry, String feedUri) {
        this(entry);
        this.feedUri = feedUri;
    }

    private String extractContent(Entry entry) {
        if (entry.getContents().isEmpty()) {
            return null;
        }
        String value = ((Content)entry.getContents().get(0)).getValue();
        return value.replaceFirst("^<!\\[CDATA\\[", "").replaceFirst("\\]\\]>$", "");
    }

    public String getContent() {
        return this.content;
    }

    public String getId() {
        return this.id;
    }

    public String toString() {
        return "Event{id='" + this.id + '\'' + ", content='" + this.content + '\'' + '}';
    }

    public String getFeedUri() {
        return this.feedUri;
    }
}

