/*
 * Decompiled with CFR 0.152.
 */
package org.ict4h.atomfeed.client.api;

import com.sun.syndication.feed.atom.Entry;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.ict4h.atomfeed.client.AtomFeedClientException;
import org.ict4h.atomfeed.client.FeedEnumerator;
import org.ict4h.atomfeed.client.api.FeedClient;
import org.ict4h.atomfeed.client.api.data.Event;
import org.ict4h.atomfeed.client.domain.Marker;
import org.ict4h.atomfeed.client.repository.AllFeeds;
import org.ict4h.atomfeed.client.repository.AllMarkers;

public class AtomFeedClient
implements FeedClient {
    private static final String ATOM_MEDIA_TYPE = "application/atom+xml";
    private AllFeeds allFeeds;
    private AllMarkers allMarkers;

    public AtomFeedClient(AllFeeds allFeeds, AllMarkers allMarkers) {
        this.allFeeds = allFeeds;
        this.allMarkers = allMarkers;
    }

    @Override
    public List<Event> unprocessedEvents(URI feedUri) {
        try {
            Marker marker = this.allMarkers.get(feedUri);
            FeedEnumerator feedEnumerator = new FeedEnumerator(this.allFeeds, feedUri);
            List<Entry> entries = marker != null ? feedEnumerator.newerEntries(marker.getEntryId()) : feedEnumerator.getAllEntries();
            ArrayList<Event> events = new ArrayList<Event>();
            for (Entry entry : entries) {
                events.add(new Event(entry));
            }
            return events;
        }
        catch (URISyntaxException e) {
            throw new AtomFeedClientException(e);
        }
    }

    @Override
    public void processedTo(URI feedUri, String entryId) {
        this.allMarkers.processedTo(feedUri, entryId);
    }
}

