/*
 * Decompiled with CFR 0.152.
 */
package org.ict4h.atomfeed.client;

import com.sun.syndication.feed.atom.Entry;
import com.sun.syndication.feed.atom.Feed;
import com.sun.syndication.feed.atom.Link;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.ict4h.atomfeed.client.repository.AllFeeds;

public class FeedEnumerator {
    private AllFeeds allFeeds;
    private URI startingURI;
    private static Logger logger = Logger.getLogger(FeedEnumerator.class);

    public FeedEnumerator(AllFeeds allFeeds, URI startingURI) {
        this.allFeeds = allFeeds;
        this.startingURI = startingURI;
    }

    public List<Entry> newerEntries(String lastReadEntryId) throws URISyntaxException {
        ArrayList<Entry> entries = new ArrayList<Entry>();
        Iterable<Entry> history = this.history();
        for (Entry entry : history) {
            if (entry.getId().equals(lastReadEntryId)) {
                Collections.reverse(entries);
                return entries;
            }
            entries.add(entry);
        }
        throw new RuntimeException("Entry not found.");
    }

    public List<Entry> getAllEntries() throws URISyntaxException {
        ArrayList<Entry> entries = new ArrayList<Entry>();
        for (Entry entry : this.history()) {
            entries.add(entry);
        }
        Collections.reverse(entries);
        return entries;
    }

    private URI getUriFromNamedLink(String relValue, Feed feed) throws URISyntaxException {
        for (Object obj : feed.getOtherLinks()) {
            Link l = (Link)obj;
            if (!l.getRel().equals(relValue)) continue;
            return new URI(l.getHref());
        }
        return null;
    }

    private Iterable<Entry> history() {
        return new Iterable<Entry>(){

            @Override
            public Iterator<Entry> iterator() {
                return new Iterator<Entry>(){
                    Feed feed;
                    List<Entry> entries;
                    {
                        this.feed = FeedEnumerator.this.allFeeds.getFor(FeedEnumerator.this.startingURI);
                        this.setEntries();
                    }

                    private void setEntries() {
                        this.entries = this.feed.getEntries();
                        Collections.reverse(this.entries);
                    }

                    private URI prev() {
                        try {
                            return FeedEnumerator.this.getUriFromNamedLink("prev-archive", this.feed);
                        }
                        catch (URISyntaxException e) {
                            throw new RuntimeException("Bad prev link.");
                        }
                    }

                    @Override
                    public boolean hasNext() {
                        return !this.entries.isEmpty();
                    }

                    @Override
                    public Entry next() {
                        Entry entry = this.entries.get(0);
                        this.remove();
                        return entry;
                    }

                    @Override
                    public void remove() {
                        this.entries.remove(0);
                        if (this.prev() != null && this.entries.isEmpty()) {
                            this.feed = FeedEnumerator.this.allFeeds.getFor(this.prev());
                            this.setEntries();
                        }
                    }
                };
            }
        };
    }
}

