/*
 * Decompiled with CFR 0.152.
 */
package org.icij.datashare.text;

import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Date;
import java.util.Objects;
import org.icij.datashare.user.User;

public class Tag {
    public final String label;
    public final Date creationDate;
    public final User user;

    public Tag(String label) {
        this(label, User.nullUser());
    }

    public Tag(String label, User user) {
        this(label, user, new Date());
    }

    public Tag(String label, User user, Date creationDate) {
        this.label = label;
        this.user = user;
        this.creationDate = creationDate;
    }

    @JsonCreator
    public static Tag tag(String label) {
        return new Tag(label);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Tag tag = (Tag)o;
        return Objects.equals(this.label, tag.label);
    }

    public int hashCode() {
        return Objects.hash(this.label);
    }

    public String toString() {
        return "Tag{label='" + this.label + "'}";
    }
}

