/*
 * Decompiled with CFR 0.152.
 */
package org.icij.datashare.function;

import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import org.icij.datashare.function.ThrowingFunction;

@FunctionalInterface
public interface ThrowingConsumer<T>
extends Consumer<T> {
    @Override
    default public void accept(T t) {
        try {
            this.acceptThrows(t);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void acceptThrows(T var1) throws Exception;

    default public <V> ThrowingConsumer<V> compose(ThrowingFunction<? super V, ? extends T> before) {
        Objects.requireNonNull(before);
        try {
            return v -> this.accept(before.apply((Object)v));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    default public <V> ThrowingConsumer<V> compose(Function<? super V, ? extends T> before) {
        Objects.requireNonNull(before);
        try {
            return v -> this.accept(before.apply((Object)v));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    default public ThrowingConsumer<T> andThen(ThrowingConsumer<? super T> after) {
        Objects.requireNonNull(after);
        try {
            return t -> {
                this.accept(t);
                after.accept(t);
            };
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    default public ThrowingConsumer<T> andThen(Consumer<? super T> after) {
        Objects.requireNonNull(after);
        try {
            return t -> {
                this.accept(t);
                after.accept(t);
            };
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

