/*
 * Decompiled with CFR 0.152.
 */
package org.icij.datashare.text;

import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.icij.datashare.function.Pair;
import org.icij.datashare.text.Language;
import org.icij.datashare.text.NamedEntity;
import org.icij.datashare.text.nlp.Pipeline;

public class NamedEntitiesBuilder {
    private final Pipeline.Type type;
    private final String docId;
    private final Language language;
    private final Map<Pair<String, NamedEntity.Category>, List<Long>> mentionIndicesMap = new LinkedHashMap<Pair<String, NamedEntity.Category>, List<Long>>();
    private String rootId;

    public NamedEntitiesBuilder(Pipeline.Type type, String docId, Language language) {
        this.type = type;
        this.docId = docId;
        this.language = language;
        this.rootId = docId;
    }

    public List<NamedEntity> build() {
        return this.mentionIndicesMap.entrySet().stream().map(e -> NamedEntity.create((NamedEntity.Category)((Pair)e.getKey())._2(), (String)((Pair)e.getKey())._1(), (List)e.getValue(), this.docId, this.rootId, this.type, this.language)).collect(Collectors.toList());
    }

    public NamedEntitiesBuilder add(NamedEntity.Category category, String mention, long index) {
        this.mentionIndicesMap.putIfAbsent(new Pair<String, NamedEntity.Category>(mention, category), new LinkedList());
        this.mentionIndicesMap.computeIfPresent(new Pair<String, NamedEntity.Category>(mention, category), (k, v) -> {
            v.add(index);
            return v;
        });
        return this;
    }

    public NamedEntitiesBuilder withRoot(String rootId) {
        this.rootId = rootId;
        return this;
    }
}

