/*
 * Decompiled with CFR 0.152.
 */
package org.icij.datashare.function;

import java.util.Objects;
import java.util.function.Function;

@FunctionalInterface
public interface QuadFunction<A, B, C, D, R> {
    public R apply(A var1, B var2, C var3, D var4);

    default public <S> QuadFunction<A, B, C, D, S> andThen(Function<? super R, ? extends S> after) {
        Objects.requireNonNull(after);
        return (a, b, c, d) -> after.apply((R)this.apply(a, b, c, d));
    }

    default public <T> QuadFunction<T, B, C, D, R> compose(Function<? super T, ? extends A> before) {
        Objects.requireNonNull(before);
        return (t, b, c, d) -> this.apply(before.apply(t), b, c, d);
    }

    public static <A, B, C, D, R> Function<A, Function<B, Function<C, Function<D, R>>>> curry(QuadFunction<A, B, C, D, R> f) {
        return a -> b -> c -> d -> f.apply(a, b, c, d);
    }

    public static <A, B, C, D, R> QuadFunction<A, B, C, D, R> uncurry(Function<A, Function<B, Function<C, Function<D, R>>>> f) {
        return (a, b, c, d) -> ((Function)((Function)((Function)f.apply(a)).apply(b)).apply(c)).apply(d);
    }
}

