/*
 * Decompiled with CFR 0.152.
 */
package org.icij.datashare.function;

import java.util.Iterator;
import java.util.Objects;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.icij.datashare.text.Language;

public class Functions {
    public static final Function<String, String> capitalize = str -> str.substring(0, 1).toUpperCase() + str.substring(1).toLowerCase();
    public static final Function<String, Language> parseLanguage = Language::parse;

    public static <A, B, C> Stream<C> zip(Stream<? extends A> a, Stream<? extends B> b, final BiFunction<? super A, ? super B, ? extends C> zipper) {
        Objects.requireNonNull(zipper);
        Spliterator spliterA = Objects.requireNonNull(a).spliterator();
        Spliterator spliterB = Objects.requireNonNull(b).spliterator();
        int charcs = spliterA.characteristics() & spliterB.characteristics() & 0xFFFFFFFA;
        long zipSize = (charcs & 0x40) != 0 ? Math.min(spliterA.getExactSizeIfKnown(), spliterB.getExactSizeIfKnown()) : -1L;
        final Iterator aIter = Spliterators.iterator(spliterA);
        final Iterator bIter = Spliterators.iterator(spliterB);
        Iterator cIter = new Iterator<C>(){

            @Override
            public boolean hasNext() {
                return aIter.hasNext() && bIter.hasNext();
            }

            @Override
            public C next() {
                return zipper.apply(aIter.next(), bIter.next());
            }
        };
        Spliterator split = Spliterators.spliterator(cIter, zipSize, charcs);
        return a.isParallel() || b.isParallel() ? StreamSupport.stream(split, true) : StreamSupport.stream(split, false);
    }
}

