/*
 * Decompiled with CFR 0.152.
 */
package org.icij.datashare.batch;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Closeable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.icij.datashare.batch.BatchSearch;
import org.icij.datashare.batch.BatchSearchRecord;
import org.icij.datashare.batch.SearchException;
import org.icij.datashare.batch.SearchResult;
import org.icij.datashare.text.Document;
import org.icij.datashare.user.User;

public interface BatchSearchRepository
extends Closeable {
    public boolean save(BatchSearch var1);

    public boolean saveResults(String var1, String var2, List<Document> var3);

    public boolean setState(String var1, BatchSearchRecord.State var2);

    public boolean setState(String var1, SearchException var2);

    public boolean deleteAll(User var1);

    public boolean delete(User var1, String var2);

    public BatchSearch get(String var1);

    public List<BatchSearchRecord> getRecords(User var1, List<String> var2);

    public int getTotal(User var1, List<String> var2, WebQuery var3);

    public List<BatchSearchRecord> getRecords(User var1, List<String> var2, WebQuery var3);

    public List<String> getQueued();

    public List<SearchResult> getResults(User var1, String var2);

    public List<SearchResult> getResults(User var1, String var2, WebQuery var3);

    public boolean publish(User var1, String var2, boolean var3);

    public BatchSearch get(User var1, String var2);

    public boolean reset(String var1);

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class WebQuery {
        public static final String DEFAULT_SORT_FIELD = "doc_nb";
        public final String sort;
        public final String order;
        public final String query;
        public final String field;
        public final int from;
        public final int size;
        public final List<String> queries;

        @JsonCreator
        public WebQuery(@JsonProperty(value="size") int size, @JsonProperty(value="from") int from, @JsonProperty(value="sort") String sort, @JsonProperty(value="order") String order, @JsonProperty(value="query") String query, @JsonProperty(value="field") String field, @JsonProperty(value="queries") List<String> queries) {
            this.size = size;
            this.from = from;
            this.sort = sort == null ? DEFAULT_SORT_FIELD : sort;
            this.query = query;
            this.field = field;
            this.order = sort == null ? "asc" : order;
            this.queries = queries == null ? null : Collections.unmodifiableList(queries);
        }

        public WebQuery(int size, int from) {
            this(size, from, null, null, "*", "all", null);
        }

        public WebQuery() {
            this(0, 0, null, null, "*", "all", null);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            WebQuery that = (WebQuery)o;
            return this.from == that.from && this.size == that.size && Objects.equals(this.sort, that.sort) && Objects.equals(this.order, that.order) && Objects.equals(this.query, that.query) && Objects.equals(this.field, that.field) && Objects.equals(this.queries, that.queries);
        }

        public int hashCode() {
            return Objects.hash(this.sort, this.order, this.query, this.field, this.from, this.size, this.queries);
        }

        public boolean hasFilteredQueries() {
            return this.queries != null && !this.queries.isEmpty();
        }

        public boolean isSorted() {
            return !DEFAULT_SORT_FIELD.equals(this.sort);
        }
    }
}

