/*
 * Decompiled with CFR 0.152.
 */
package org.icij.datashare.time;

import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.icij.datashare.time.DatashareDateUtils;
import org.icij.datashare.time.DateChangeListener;
import org.icij.datashare.time.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatashareMockTime
implements Time {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Date mockDate = new Date();
    private final List<DateChangeListener> listeners = new LinkedList<DateChangeListener>();

    @Override
    public void setMockDate(Date mockDate) {
        this.logger.debug("mock time in datashare : " + mockDate);
        this.mockDate = mockDate;
        this.notifyListeners();
    }

    @Override
    public void sleep(int milliseconds) {
        this.addMilliseconds(milliseconds);
    }

    @Override
    public void setMockDate(String dateTime) {
        this.setMockDate(DatashareDateUtils.formatDate(dateTime));
    }

    @Override
    public void addMilliseconds(int timeToAddInMs) {
        this.setMockDate(DatashareDateUtils.addMilliseconds(this.now(), timeToAddInMs));
    }

    protected void notifyListeners() {
        for (DateChangeListener listener : this.listeners) {
            listener.dateChanged();
        }
    }

    @Override
    public Date now() {
        return this.mockDate;
    }

    @Override
    public long currentTimeMillis() {
        return this.mockDate.getTime();
    }

    public void register(DateChangeListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public Date itIsNow(String date) {
        this.setMockDate(date);
        return this.now();
    }
}

