/*
 * Decompiled with CFR 0.152.
 */
package org.icij.datashare.batch;

import java.nio.file.Path;
import java.util.Objects;
import java.util.Optional;
import org.icij.datashare.text.Project;

public class BatchDownload {
    public final Project project;
    public final Path filename;
    public final String queryString;

    public BatchDownload(Project project, Path filename, String queryString) {
        this.project = Optional.ofNullable(project).orElseThrow(() -> new IllegalArgumentException("project cannot be null or empty"));
        this.queryString = Optional.ofNullable(queryString).orElseThrow(() -> new IllegalArgumentException("query cannot be null or empty"));
        this.filename = Optional.ofNullable(filename).orElseThrow(() -> new IllegalArgumentException("filename cannot be null or empty"));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BatchDownload that = (BatchDownload)o;
        return Objects.equals(this.project, that.project) && Objects.equals(this.filename, that.filename) && Objects.equals(this.queryString, that.queryString);
    }

    public int hashCode() {
        return Objects.hash(this.project, this.filename, this.queryString);
    }
}

