package org.icij.datashare.text;

import java.io.Serializable;
import java.util.Locale;


public enum Language implements Serializable {
    // from https://en.wikipedia.org/wiki/List_of_ISO_639-1_codes
    ABKHAZIAN("ab", "abk"),
    AFAR("aa", "aar"),
    AFRIKAANS("af", "afr"),
    AKAN("ak", "aka"),
    ALBANIAN("sq", "sqi"),
    AMHARIC("am", "amh"),
    ARABIC("ar", "ara"),
    ARAGONESE("an", "arg"),
    ARMENIAN("hy", "hye"),
    ASSAMESE("as", "asm"),
    AVARIC("av", "ava"),
    AVESTAN("ae", "ave"),
    AYMARA("ay", "aym"),
    AZERBAIJANI("az", "aze"),
    BAMBARA("bm", "bam"),
    BASHKIR("ba", "bak"),
    BASQUE("eu", "eus"),
    BELARUSIAN("be", "bel"),
    BENGALI("bn", "ben"),
    BIHARI("bh", "bih"),
    BISLAMA("bi", "bis"),
    BOSNIAN("bs", "bos"),
    BRETON("br", "bre"),
    BULGARIAN("bg", "bul"),
    BURMESE("my", "mya"),
    CATALAN("ca", "cat"),
    CHAMORRO("ch", "cha"),
    CHECHEN("ce", "che"),
    CHICHEWA("ny", "nya"),
    CHINESE("zh", "zho"),
    CHUVASH("cv", "chv"),
    CORNISH("kw", "cor"),
    CORSICAN("co", "cos"),
    CREE("cr", "cre"),
    CROATIAN("hr", "hrv"),
    CZECH("cs", "ces"),
    DANISH("da", "dan"),
    MALDIVIAN("dv", "div"),
    DUTCH("nl", "nld"),
    DZONGKHA("dz", "dzo"),
    ENGLISH("en", "eng"),
    ESPERANTO("eo", "epo"),
    ESTONIAN("et", "est"),
    EWE("ee", "ewe"),
    FAROESE("fo", "fao"),
    FIJIAN("fj", "fij"),
    FINNISH("fi", "fin"),
    FRENCH("fr", "fra"),
    FULAH("ff", "ful"),
    GALICIAN("gl", "glg"),
    GEORGIAN("ka", "kat"),
    GERMAN("de", "deu"),
    GREEK("el", "ell"),
    GUARANI("gn", "grn"),
    GUJARATI("gu", "guj"),
    HAITIAN("ht", "hat"),
    HAUSA("ha", "hau"),
    HEBREW("he", "heb"),
    HERERO("hz", "her"),
    HINDI("hi", "hin"),
    HIRIMOTU("ho", "hmo"),
    HUNGARIAN("hu", "hun"),
    INTERLINGUA("ia", "ina"),
    INDONESIAN("id", "ind"),
    INTERLIGUE("ie", "ile"),
    IRISH("ga", "gle"),
    IGBO("ig", "ibo"),
    INUPIAQ("ik", "ipk"),
    IDO("io", "ido"),
    ICELANDIC("is", "isl"),
    ITALIAN("it", "ita"),
    INUKTITUT("iu", "iku"),
    JAPANESE("ja", "jpn"),
    JAVANESE("jv", "jav"),
    GREENLANDIC("kl", "kal"),
    KANNADA("kn", "kan"),
    KANURI("kr", "kau"),
    KASHMIRI("ks", "kas"),
    KAZAKH("kk", "kaz"),
    CENTRALKHMER("km", "khm"),
    KIKUYU("ki", "kik"),
    KINYARWANDA("rw", "kin"),
    KIRGHIZ("ky", "kir"),
    KOMI("kv", "kom"),
    KONGO("kg", "kon"),
    KOREAN("ko", "kor"),
    KURDISH("ku", "kur"),
    KUANYAMA("kj", "kua"),
    LATIN("la", "lat"),
    LUXEMBOURGISH("lb", "ltz"),
    GANDA("lg", "lug"),
    LIMBURGAN("li", "lim"),
    LINGALA("ln", "lin"),
    LAO("lo", "lao"),
    LITHUANIAN("lt", "lit"),
    LUBAKATANGA("lu", "lub"),
    LATVIAN("lv", "lav"),
    MANX("gv", "glv"),
    MACEDONIAN("mk", "mkd"),
    MALAGASY("mg", "mlg"),
    MALAY("ms", "msa"),
    MALAYALAM("ml", "mal"),
    MALTESE("mt", "mlt"),
    MAORI("mi", "mri"),
    MARATHI("mr", "mar"),
    MARSHALLESE("mh", "mah"),
    MONGOLIAN("mn", "mon"),
    NAURU("na", "nau"),
    NAVAJO("nv", "nav"),
    NORTHNDEBELE("nd", "nde"),
    NEPALI("ne", "nep"),
    NDONGA("ng", "ndo"),
    NORWEGIANBOKMAL("nb", "nob"),
    NORWEGIANNYNORSK("nn", "nno"),
    NORWEGIAN("no", "nor"),
    SICHUANYI("ii", "iii"),
    SOUTHNDEBELE("nr", "nbl"),
    OCCITAN("oc", "oci"),
    OJIBWA("oj", "oji"),
    OLDSLAVONIC("cu", "chu"),
    OROMO("om", "orm"),
    ORIYA("or", "ori"),
    OSSETIAN("os", "oss"),
    PANJABI("pa", "pan"),
    PALI("pi", "pli"),
    PERSIAN("fa", "fas"),
    POLISH("pl", "pol"),
    PASHTO("ps", "pus"),
    PORTUGUESE("pt", "por"),
    QUECHUA("qu", "que"),
    ROMANSH("rm", "roh"),
    ROMANIAN("ro", "ron"),
    RUNDI("rn", "run"),
    MOLDAVIAN("ro", "ron"),
    MOLDOVAN("ro", "ron"),
    RUSSIAN("ru", "rus"),
    SANSKRIT("sa", "san"),
    SARDINIAN("sc", "srd"),
    SINDHI("sd", "snd"),
    NORTHERNSAMI("se", "sme"),
    SAMOAN("sm", "smo"),
    SANGO("sg", "sag"),
    SERBIAN("sr", "srp"),
    GAELIC("gd", "gla"),
    SHONA("sn", "sna"),
    SINHALESE("si", "sin"),
    SLOVAK("sk", "slk"),
    SLOVENIAN("sl", "slv"),
    SOMALI("so", "som"),
    SOUTHERNSOTHO("st", "sot"),
    SPANISH("es", "spa"),
    SUNDANESE("su", "sun"),
    SWAHILI("sw", "swa"),
    SWATI("ss", "ssw"),
    SWEDISH("sv", "swe"),
    TAMIL("ta", "tam"),
    TELUGU("te", "tel"),
    TAJIK("tg", "tgk"),
    THAI("th", "tha"),
    TIGRINYA("ti", "tir"),
    TIBETAN("bo", "bod"),
    TURKMEN("tk", "tuk"),
    TAGALOG("tl", "tgl"),
    TSWANA("tn", "tsn"),
    TONGA("to", "ton"),
    TURKISH("tr", "tur"),
    TSONGA("ts", "tso"),
    TATAR("tt", "tat"),
    TWI("tw", "twi"),
    TAHITIAN("ty", "tah"),
    UIGHUR("ug", "uig"),
    UKRAINIAN("uk", "ukr"),
    URDU("ur", "urd"),
    UZBEK("uz", "uzb"),
    VENDA("ve", "ven"),
    VIETNAMESE("vi", "vie"),
    VOLAPUK("vo", "vol"),
    WALLOON("wa", "wln"),
    WELSH("cy", "cym"),
    WOLOF("wo", "wol"),
    WESTERNFRISIAN("fy", "fry"),
    XHOSA("xh", "xho"),
    YIDDISH("yi", "yid"),
    YORUBA("yo", "yor"),
    ZHUANG("za", "zha"),
    ZULU("zu", "zul"),
    UNKNOWN("un", "ukn");

    private static final long serialVersionUID =-7964823164978231L;

    private final String iso6391Code;
    private final String iso6392Code;

    Language(final String iso1Code, final String iso2Code) {
        iso6391Code = iso1Code;
        iso6392Code = iso2Code;
    }

    public String iso6391Code() { return iso6391Code; }
    public String iso6392Code() { return iso6392Code; }

    public static Language parse(final String language) {
        if (language == null || language.isEmpty()) {
            return UNKNOWN;
        }
        for (Language lang : Language.values()) {
            if (language.equalsIgnoreCase(lang.iso6391Code()) || language.equalsIgnoreCase(lang.iso6392Code())) {
                return lang;
            }
        }
        return valueOf(language.toUpperCase(Locale.ROOT));
    }

}
