/*
 * Decompiled with CFR 0.152.
 */
package org.icij.datashare.time;

import java.security.AccessControlException;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.icij.datashare.time.DatashareMockTime;
import org.icij.datashare.time.Time;

public class DatashareTime
implements Time {
    private static final Log logger = LogFactory.getLog(DatashareTime.class);
    public static final String DATASHARE_TIME_CLASS_PROPERTY = "datashare.time";
    private static final Time defaultInstance = new DatashareTime();
    private static Time systemPropertyInstance;

    private DatashareTime() {
    }

    public static Time getInstance() {
        String datashareTimeClassName;
        try {
            datashareTimeClassName = System.getProperty(DATASHARE_TIME_CLASS_PROPERTY);
        }
        catch (AccessControlException e) {
            datashareTimeClassName = null;
        }
        if (datashareTimeClassName != null) {
            try {
                Class<?> datashareMockTimeClass = Class.forName(datashareTimeClassName);
                if (systemPropertyInstance == null || !datashareTimeClassName.equals(systemPropertyInstance.getClass().getName())) {
                    systemPropertyInstance = (Time)datashareMockTimeClass.newInstance();
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("time instance for datashare : <" + datashareTimeClassName + ">"));
                    }
                }
                return systemPropertyInstance;
            }
            catch (ClassNotFoundException | InstantiationException e) {
                DatashareTime.logErrorInstance(datashareTimeClassName);
            }
            catch (IllegalAccessException e) {
                logger.warn((Object)("No empty constructor for : <" + datashareTimeClassName + "> returning default instance"));
            }
        }
        return defaultInstance;
    }

    @Override
    public Date now() {
        return new Date();
    }

    public static Date getNow() {
        return DatashareTime.getInstance().now();
    }

    @Override
    public long currentTimeMillis() {
        return System.currentTimeMillis();
    }

    @Override
    public void setMockDate(Date date) {
        throw new UnsupportedOperationException("DatashareTime is in real time mode");
    }

    @Override
    public void sleep(int milliseconds) throws InterruptedException {
        Thread.sleep(milliseconds);
    }

    @Override
    public void setMockDate(String dateTime) {
        throw new UnsupportedOperationException("DatashareTime is in real time mode");
    }

    @Override
    public void addMilliseconds(int toBeAddedInMilliseconds) {
        throw new UnsupportedOperationException("DatashareTime is in real time mode");
    }

    private static void logErrorInstance(String datashareTimeClassName) {
        logger.error((Object)("Cannot instantiate class : <" + datashareTimeClassName + "> returning default instance"));
    }

    public static void setMockTime(boolean mockTime) {
        if (mockTime) {
            System.setProperty(DATASHARE_TIME_CLASS_PROPERTY, DatashareMockTime.class.getCanonicalName());
        } else {
            System.clearProperty(DATASHARE_TIME_CLASS_PROPERTY);
        }
    }

    public static boolean isMockTime() {
        return System.getProperty(DATASHARE_TIME_CLASS_PROPERTY) != null;
    }

    @Override
    public Date itIsNow(String date) {
        throw new UnsupportedOperationException("DatashareTime is in real time mode");
    }
}

