/*
 * Decompiled with CFR 0.152.
 */
package org.icij.datashare.text;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.net.InetSocketAddress;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.regex.Pattern;
import org.icij.datashare.Entity;

public class Project
implements Entity {
    private static final long serialVersionUID = 2568979856231459L;
    public final String name;
    public final Path sourcePath;
    @JsonIgnore
    public final String allowFromMask;
    @JsonIgnore
    private final Pattern pattern;

    public Project(String corpusName) {
        this(corpusName, Paths.get("/vault", new String[0]).resolve(corpusName), "*");
    }

    public Project(@JsonProperty(value="name") String corpusName, @JsonProperty(value="sourcePath") Path sourcePath) {
        this(corpusName, sourcePath, "*");
    }

    public Project(String corpusName, Path source, String allowFromMask) {
        this.name = corpusName;
        this.sourcePath = source;
        this.allowFromMask = allowFromMask;
        this.pattern = Pattern.compile(allowFromMask.replace(".", "\\.").replace("*", "\\d{1,3}"));
    }

    public Project(String corpusName, String allowFromMask) {
        this(corpusName, Paths.get("/vault", new String[0]).resolve(corpusName), allowFromMask);
    }

    public boolean isAllowed(InetSocketAddress socketAddress) {
        return this.pattern.matcher(socketAddress.getAddress().getHostAddress()).matches();
    }

    public static boolean isAllowed(Project project, InetSocketAddress socketAddress) {
        return project == null || project.isAllowed(socketAddress);
    }

    @Override
    @JsonIgnore
    public String getId() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public Path getSourcePath() {
        return this.sourcePath;
    }

    public static Project project(String projectName) {
        return new Project(projectName);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Project project = (Project)o;
        return this.name.equals(project.name);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    public String toString() {
        return "Project{name='" + this.name + '\'' + '}';
    }
}

