/*
 * Decompiled with CFR 0.152.
 */
package org.icij.datashare.extension;

import java.io.FileNotFoundException;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.icij.datashare.PropertiesProvider;
import org.icij.datashare.extension.ExtensionLoader;
import org.icij.datashare.text.nlp.Pipeline;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipelineRegistry {
    protected final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private final Path pluginDir;
    private final PropertiesProvider propertiesProvider;
    private final Map<Pipeline.Type, Pipeline> pipelines = new HashMap<Pipeline.Type, Pipeline>();

    public PipelineRegistry(PropertiesProvider propertiesProvider) {
        this.pluginDir = Paths.get(propertiesProvider.get("extensionsDir").orElse("./extensions"), new String[0]);
        this.propertiesProvider = propertiesProvider;
    }

    public Pipeline get(Pipeline.Type type) {
        return this.pipelines.get(type);
    }

    public Set<Pipeline.Type> getPipelineTypes() {
        return this.pipelines.keySet();
    }

    public void register(Class<? extends Pipeline> pipelineClass) {
        try {
            Pipeline abstractPipeline = pipelineClass.getDeclaredConstructor(PropertiesProvider.class).newInstance(this.propertiesProvider);
            this.pipelines.put(abstractPipeline.getType(), abstractPipeline);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public void register(Pipeline.Type type) {
        try {
            this.register(Class.forName(type.getClassName()));
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public synchronized void load() throws FileNotFoundException {
        new ExtensionLoader(this.pluginDir).load(this::register, Pipeline.class::isAssignableFrom);
    }
}

