/*
 * Decompiled with CFR 0.152.
 */
package org.icij.datashare.extension;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtensionLoader {
    protected final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private final Path extensionsDir;

    public ExtensionLoader(Path extensionsDir) {
        this.extensionsDir = extensionsDir;
    }

    public synchronized <T> void load(Consumer<T> registerFunc, Predicate<Class<?>> predicate) throws FileNotFoundException {
        File[] jars = Optional.ofNullable(this.extensionsDir.toFile().listFiles((file, s) -> s.endsWith(".jar"))).orElseThrow(() -> new FileNotFoundException("invalid path for plugins: " + this.extensionsDir));
        URLClassLoader classLoader = (URLClassLoader)ClassLoader.getSystemClassLoader();
        for (File jar : jars) {
            try {
                Class<?> expectedClass = this.findClassesInJar(predicate, jar);
                if (expectedClass == null) continue;
                this.LOGGER.info("loading class {} and its jar {}", expectedClass, (Object)jar);
                Method method = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
                method.setAccessible(true);
                method.invoke((Object)classLoader, classLoader.getResource(jar.toString()));
                registerFunc.accept(expectedClass);
            }
            catch (IOException | ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                this.LOGGER.error("Cannot load jar " + jar, (Throwable)e);
            }
        }
    }

    synchronized <T> Class<?> findClassesInJar(Predicate<Class<?>> predicate, File jarFile) throws IOException, ClassNotFoundException {
        URLClassLoader ucl = new URLClassLoader(new URL[]{jarFile.toURI().toURL()}, this.getClass().getClassLoader());
        JarInputStream jarInputStream = new JarInputStream(new FileInputStream(jarFile));
        JarEntry jarEntry = jarInputStream.getNextJarEntry();
        while (jarEntry != null) {
            if (jarEntry.getName().endsWith(".class")) {
                Class<?> myLoadedClass;
                String classname = jarEntry.getName().replaceAll("/", "\\.");
                if (!(classname = classname.substring(0, classname.length() - 6)).contains("$") && predicate.test(myLoadedClass = Class.forName(classname, true, ucl)) && !myLoadedClass.isInterface() && !Modifier.isAbstract(myLoadedClass.getModifiers())) {
                    return myLoadedClass;
                }
            }
            jarEntry = jarInputStream.getNextJarEntry();
        }
        return null;
    }
}

