/*
 * Decompiled with CFR 0.152.
 */
package org.icij.datashare.text.nlp;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.icij.datashare.text.Language;
import org.icij.datashare.text.NamedEntity;
import org.icij.datashare.text.nlp.NlpStage;
import org.icij.datashare.text.nlp.NlpTag;
import org.icij.datashare.text.nlp.Pipeline;

public class Annotations {
    private final String documentId;
    private final Pipeline.Type pipelineType;
    private final Language language;
    private final Map<NlpStage, List<NlpTag>> tags;

    public Annotations(String documentId, Pipeline.Type pipelineType, Language language) {
        this.documentId = documentId;
        this.pipelineType = pipelineType;
        this.language = language;
        this.tags = new HashMap<NlpStage, List<NlpTag>>(){
            {
                Arrays.stream(NlpStage.values()).forEach((? super T stage) -> {
                    List cfr_ignored_0 = this.put(stage, new ArrayList());
                });
            }
        };
    }

    public String getDocumentId() {
        return this.documentId;
    }

    public Language getLanguage() {
        return this.language;
    }

    public Pipeline.Type getPipelineType() {
        return this.pipelineType;
    }

    public List<NlpTag> get(NlpStage stage) {
        return this.tags.get((Object)stage);
    }

    public void add(NlpStage stage, int begin, int end) {
        this.tags.get((Object)stage).add(new NlpTag(stage, begin, end));
    }

    public void add(NlpStage stage, int begin, int end, NamedEntity.Category value) {
        this.tags.get((Object)stage).add(new NlpTag(stage, begin, end, value));
    }
}

