/*
 * Decompiled with CFR 0.152.
 */
package org.icij.datashare.text.nlp;

import java.lang.reflect.InvocationTargetException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.icij.datashare.PropertiesProvider;
import org.icij.datashare.function.ThrowingFunctions;
import org.icij.datashare.text.Document;
import org.icij.datashare.text.Language;
import org.icij.datashare.text.NamedEntity;
import org.icij.datashare.text.nlp.Annotations;
import org.icij.datashare.text.nlp.NlpStage;
import org.icij.datashare.text.nlp.Pipeline;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPipeline
implements Pipeline {
    public static final String NLP_STAGES_PROP = "nlpStages";
    protected final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    protected final Charset encoding;
    protected final Map<NlpStage, List<NlpStage>> stageDependencies;
    protected final List<NlpStage> targetStages;
    protected final List<NamedEntity.Category> targetEntities;
    protected final boolean caching;
    protected List<NlpStage> stages;

    protected AbstractPipeline(Properties properties) {
        this.targetEntities = ThrowingFunctions.getProperty(Pipeline.Property.ENTITIES.getName(), properties, ThrowingFunctions.removeSpaces.andThen(ThrowingFunctions.splitComma).andThen(NamedEntity.Category.parseAll)).orElse(DEFAULT_ENTITIES);
        this.targetStages = ThrowingFunctions.getProperty(NLP_STAGES_PROP, properties, ThrowingFunctions.removeSpaces.andThen(ThrowingFunctions.splitComma).andThen(NlpStage.parseAll)).orElse(DEFAULT_TARGET_STAGES);
        this.encoding = ThrowingFunctions.getProperty(Pipeline.Property.ENCODING.getName(), properties, ThrowingFunctions.parseCharset.compose(String::trim)).orElse(DEFAULT_ENCODING);
        this.caching = ThrowingFunctions.getProperty(Pipeline.Property.CACHING.getName(), properties, ThrowingFunctions.trim.andThen(Boolean::parseBoolean)).orElse(true);
        this.stageDependencies = new HashMap<NlpStage, List<NlpStage>>(){
            {
                Arrays.stream(NlpStage.values()).forEach((? super T stage) -> {
                    List cfr_ignored_0 = this.put(stage, new ArrayList());
                });
            }
        };
    }

    @Override
    public Pipeline.Type getType() {
        return Pipeline.Type.fromClassName(this.getClass().getSimpleName()).get();
    }

    @Override
    public List<NamedEntity.Category> getTargetEntities() {
        return this.targetEntities;
    }

    @Override
    public List<NlpStage> getStages() {
        return this.stages;
    }

    @Override
    public boolean isCaching() {
        return this.caching;
    }

    @Override
    public Charset getEncoding() {
        return this.encoding;
    }

    public static AbstractPipeline create(String pipelineName, PropertiesProvider propertiesProvider) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException, ClassNotFoundException {
        Class<?> pipelineClass = Class.forName(Pipeline.Type.valueOf(pipelineName).getClassName());
        return (AbstractPipeline)pipelineClass.getDeclaredConstructor(PropertiesProvider.class).newInstance(propertiesProvider);
    }

    @Override
    public boolean initialize(Language language) throws InterruptedException {
        this.stages = this.stagesDependenciesTC(this.targetStages);
        if (!this.checkStages(language)) {
            this.LOGGER.info("initializing " + this.getType() + " Skipping... Stage unsupported for " + language + " " + this.stages);
            return false;
        }
        this.LOGGER.info("initializing " + this.getType() + " " + language + " " + this.stages);
        return true;
    }

    @Override
    public abstract Annotations process(String var1, String var2, Language var3) throws InterruptedException;

    public List<NamedEntity> processHeaders(Document doc) {
        return new LinkedList<NamedEntity>();
    }

    @Override
    public void terminate(Language language) throws InterruptedException {
        this.LOGGER.info("ending " + this.getType() + " " + language + " " + this.stages.toString());
    }

    public abstract Map<Language, Set<NlpStage>> supportedStages();

    @Override
    public boolean supports(NlpStage stage, Language language) {
        Set<NlpStage> supStagesForLang = this.supportedStages().get(language);
        if (supStagesForLang == null || supStagesForLang.isEmpty()) {
            return false;
        }
        return supStagesForLang.contains((Object)stage);
    }

    private boolean checkStages(Language language) {
        for (NlpStage stage : this.getStages()) {
            if (this.supports(stage, language)) continue;
            return false;
        }
        return true;
    }

    private List<NlpStage> stagesDependenciesTC(List<NlpStage> coreStages) {
        HashSet<NlpStage> visited = new HashSet<NlpStage>();
        ArrayList<NlpStage> tc = new ArrayList<NlpStage>();
        for (NlpStage stage : coreStages) {
            this.dfs(stage, visited, tc, this.stageDependencies);
        }
        return tc;
    }

    private void dfs(NlpStage stage, Set<NlpStage> visited, List<NlpStage> sorted, Map<NlpStage, List<NlpStage>> stagesMatrix) {
        visited.add(stage);
        stagesMatrix.get((Object)stage).forEach(stageDep -> {
            if (!visited.contains(stageDep)) {
                this.dfs((NlpStage)((Object)stageDep), visited, sorted, stagesMatrix);
            }
        });
        sorted.add(stage);
    }
}

