/*
 * Decompiled with CFR 0.152.
 */
package org.icij.datashare.function;

import java.util.Objects;
import java.util.function.Function;

@FunctionalInterface
public interface ThrowingFunction<T, R>
extends Function<T, R> {
    @Override
    default public R apply(T t) {
        try {
            return this.applyThrows(t);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public R applyThrows(T var1) throws Exception;

    @Override
    default public <V> ThrowingFunction<V, R> compose(ThrowingFunction<? super V, ? extends T> before) {
        Objects.requireNonNull(before);
        try {
            return v -> this.apply(before.apply((Object)v));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    default public <V> ThrowingFunction<V, R> compose(Function<? super V, ? extends T> before) {
        Objects.requireNonNull(before);
        try {
            return v -> this.apply(before.apply((Object)v));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    default public <V> ThrowingFunction<T, V> andThen(ThrowingFunction<? super R, ? extends V> after) {
        Objects.requireNonNull(after);
        try {
            return t -> after.apply((R)this.apply(t));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    default public <V> ThrowingFunction<T, V> andThen(Function<? super R, ? extends V> after) {
        Objects.requireNonNull(after);
        try {
            return t -> after.apply((R)this.apply(t));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> ThrowingFunction<T, T> identity() {
        return t -> t;
    }
}

