/*
 * Decompiled with CFR 0.152.
 */
package org.icij.datashare.extension;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.icij.datashare.PropertiesProvider;
import org.icij.datashare.text.nlp.Pipeline;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipelineRegistry {
    protected final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private final Path pluginDir;
    private final PropertiesProvider propertiesProvider;
    private final Map<Pipeline.Type, Pipeline> pipelines = new HashMap<Pipeline.Type, Pipeline>();

    public PipelineRegistry(PropertiesProvider propertiesProvider) {
        this.pluginDir = Paths.get(propertiesProvider.get("pluginsDir").orElse("./plugins"), new String[0]);
        this.propertiesProvider = propertiesProvider;
    }

    public Pipeline get(Pipeline.Type type) {
        return this.pipelines.get(type);
    }

    public Set<Pipeline.Type> getPipelineTypes() {
        return this.pipelines.keySet();
    }

    public void register(Class<? extends Pipeline> pipelineClass) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        Pipeline abstractPipeline = pipelineClass.getDeclaredConstructor(PropertiesProvider.class).newInstance(this.propertiesProvider);
        this.pipelines.put(abstractPipeline.getType(), abstractPipeline);
    }

    public synchronized void load() {
        File[] jars = Optional.ofNullable(this.pluginDir.toFile().listFiles((file, s) -> s.endsWith(".jar"))).orElseThrow(() -> new IllegalStateException("invalid path for plugins: " + this.pluginDir));
        URLClassLoader classLoader = (URLClassLoader)ClassLoader.getSystemClassLoader();
        for (File jar : jars) {
            try {
                Class<?> pipelineClassInJar = this.findClassesInJar(Pipeline.class, jar.toString());
                if (pipelineClassInJar == null) continue;
                this.LOGGER.info("adding pipeline {} to system classloader", pipelineClassInJar);
                Method method = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
                method.setAccessible(true);
                method.invoke((Object)classLoader, classLoader.getResource(jar.toString()));
                this.register(pipelineClassInJar);
            }
            catch (IOException | ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                this.LOGGER.error("Cannot load jar " + jar, (Throwable)e);
            }
        }
    }

    synchronized Class<?> findClassesInJar(Class<?> baseInterface, String jarName) throws IOException, ClassNotFoundException {
        String jarFullPath = File.separator + jarName;
        ClassLoader classLoader = this.getClass().getClassLoader();
        URL url = new URL("jar:file:" + jarFullPath + "!/");
        URLClassLoader ucl = new URLClassLoader(new URL[]{url}, classLoader);
        JarInputStream jarInputStream = new JarInputStream(new FileInputStream(jarFullPath));
        JarEntry jarEntry = jarInputStream.getNextJarEntry();
        while (jarEntry != null) {
            if (jarEntry.getName().endsWith(".class")) {
                Class<?> myLoadedClass;
                String classname = jarEntry.getName().replaceAll("/", "\\.");
                if (!(classname = classname.substring(0, classname.length() - 6)).contains("$") && baseInterface.isAssignableFrom(myLoadedClass = Class.forName(classname, true, ucl))) {
                    return myLoadedClass;
                }
            }
            jarEntry = jarInputStream.getNextJarEntry();
        }
        return null;
    }
}

