/*
 * Decompiled with CFR 0.152.
 */
package org.icij.datashare.batch;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.icij.datashare.text.Project;
import org.icij.datashare.user.User;

public class BatchSearch {
    public final String uuid;
    public final boolean published;
    public final Project project;
    public final String name;
    public final String description;
    public final LinkedHashMap<String, Integer> queries;
    public final State state;
    public final User user;
    private final Date date;
    public final List<String> fileTypes;
    public final List<String> paths;
    public final int fuzziness;
    public final boolean phraseMatches;
    public final int nbResults;
    public final String errorMessage;

    public BatchSearch(Project project, String name, String description, LinkedHashSet<String> queries, User user) {
        this(UUID.randomUUID().toString(), project, name, description, BatchSearch.toLinkedHashMap(queries), new Date(), State.QUEUED, user, 0, false, null, null, 0, false, null);
    }

    public BatchSearch(Project project, String name, String description, LinkedHashSet<String> queries, User user, boolean published) {
        this(UUID.randomUUID().toString(), project, name, description, BatchSearch.toLinkedHashMap(queries), new Date(), State.QUEUED, user, 0, published, null, null, 0, false, null);
    }

    public BatchSearch(Project project, String name, String description, LinkedHashSet<String> queries, User user, boolean published, List<String> fileTypes, List<String> paths, int fuzziness) {
        this(UUID.randomUUID().toString(), project, name, description, BatchSearch.toLinkedHashMap(queries), new Date(), State.QUEUED, user, 0, published, fileTypes, paths, fuzziness, false, null);
    }

    public BatchSearch(Project project, String name, String description, LinkedHashSet<String> queries, User user, boolean published, List<String> fileTypes, List<String> paths, int fuzziness, boolean phraseMatches) {
        this(UUID.randomUUID().toString(), project, name, description, BatchSearch.toLinkedHashMap(queries), new Date(), State.QUEUED, user, 0, published, fileTypes, paths, fuzziness, phraseMatches, null);
    }

    public BatchSearch(Project project, String name, String description, LinkedHashSet<String> queries, User user, boolean published, List<String> fileTypes, List<String> paths, boolean phraseMatches) {
        this(UUID.randomUUID().toString(), project, name, description, BatchSearch.toLinkedHashMap(queries), new Date(), State.QUEUED, user, 0, published, fileTypes, paths, 0, phraseMatches, null);
    }

    public BatchSearch(String uuid, Project project, String name, String description, LinkedHashSet<String> queries, Date date, State state, User user) {
        this(uuid, project, name, description, BatchSearch.toLinkedHashMap(queries), date, state, user, 0, false, null, null, 0, false, null);
    }

    public BatchSearch(Project project, String name, String description, LinkedHashSet<String> queries, Date date) {
        this(UUID.randomUUID().toString(), project, name, description, BatchSearch.toLinkedHashMap(queries), date, State.QUEUED, User.local(), 0, false, null, null, 0, false, null);
    }

    public BatchSearch(String uuid, Project project, String name, String description, LinkedHashMap<String, Integer> queries, Date date, State state, User user, int nbResults, boolean published, List<String> fileTypes, List<String> paths, int fuzziness, boolean phraseMatches, String errorMessage) {
        assert (date != null && uuid != null);
        this.uuid = uuid;
        this.project = project;
        this.name = name;
        this.user = user;
        this.description = description;
        this.queries = queries;
        this.date = date;
        this.state = state;
        this.nbResults = nbResults;
        this.published = published;
        this.fileTypes = Collections.unmodifiableList(Optional.ofNullable(fileTypes).orElse(new ArrayList()));
        this.paths = Collections.unmodifiableList(Optional.ofNullable(paths).orElse(new ArrayList()));
        this.fuzziness = fuzziness;
        this.phraseMatches = phraseMatches;
        this.errorMessage = errorMessage;
    }

    public Date getDate() {
        return this.date;
    }

    @JsonIgnore
    public List<String> getQueryList() {
        return new ArrayList<String>(this.queries.keySet());
    }

    private static LinkedHashMap<String, Integer> toLinkedHashMap(LinkedHashSet<String> queries) {
        return queries.stream().collect(Collectors.toMap(Function.identity(), i -> 0, (u, v) -> {
            throw new IllegalStateException(String.format("Duplicate key %s", u));
        }, LinkedHashMap::new));
    }

    public String toString() {
        return "BatchSearch{" + this.uuid + " name='" + this.name + '\'' + " (" + (Object)((Object)this.state) + ")}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BatchSearch that = (BatchSearch)o;
        return this.uuid.equals(that.uuid) && this.name.equals(that.name) && this.queries.equals(that.queries);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.description, this.queries);
    }

    public static enum State {
        QUEUED,
        RUNNING,
        SUCCESS,
        FAILURE;

    }
}

