/*
 * Decompiled with CFR 0.152.
 */
package org.icij.datashare.text.nlp;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.icij.datashare.text.Language;
import org.icij.datashare.text.NamedEntity;
import org.icij.datashare.text.nlp.NlpStage;
import org.icij.datashare.text.nlp.NlpTag;
import org.icij.datashare.text.nlp.Pipeline;

public class Annotations {
    public final String documentId;
    public final String rootId;
    public final Pipeline.Type pipelineType;
    public final Language language;
    private final Map<NlpStage, List<NlpTag>> tags;

    public Annotations(String documentId, Pipeline.Type pipelineType, Language language) {
        this(documentId, documentId, pipelineType, language);
    }

    public Annotations(String documentId, String rootId, Pipeline.Type pipelineType, Language language) {
        this.documentId = documentId;
        this.rootId = rootId;
        this.pipelineType = pipelineType;
        this.language = language;
        this.tags = new HashMap<NlpStage, List<NlpTag>>(){
            {
                Arrays.stream(NlpStage.values()).forEach((? super T stage) -> this.put(stage, new ArrayList()));
            }
        };
    }

    public List<NlpTag> get(NlpStage stage) {
        return this.tags.get((Object)stage);
    }

    public void add(NlpStage stage, int begin, int end) {
        this.tags.get((Object)stage).add(new NlpTag(stage, begin, end));
    }

    public void add(NlpStage stage, int begin, int end, NamedEntity.Category value) {
        this.tags.get((Object)stage).add(new NlpTag(stage, begin, end, value));
    }
}

