/*
 * Decompiled with CFR 0.152.
 */
package org.icij.datashare.text.indexing;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.stream.Stream;
import org.icij.datashare.Entity;
import org.icij.datashare.text.Document;
import org.icij.datashare.text.NamedEntity;
import org.icij.datashare.text.Project;
import org.icij.datashare.text.Tag;
import org.icij.datashare.text.indexing.ExtractedText;
import org.icij.datashare.text.indexing.SearchedText;
import org.icij.datashare.text.nlp.Pipeline;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface Indexer
extends Closeable {
    public static final Logger LOGGER = LoggerFactory.getLogger(Indexer.class);

    public Searcher search(List<String> var1, Class<? extends Entity> var2);

    public boolean createIndex(String var1) throws IOException;

    public boolean deleteAll(String var1) throws IOException;

    public boolean getHealth();

    @Override
    public void close() throws IOException;

    public boolean bulkAdd(String var1, Pipeline.Type var2, List<NamedEntity> var3, Document var4) throws IOException;

    public <T extends Entity> boolean bulkAdd(String var1, List<T> var2) throws IOException;

    public <T extends Entity> boolean bulkUpdate(String var1, List<T> var2) throws IOException;

    public <T extends Entity> void add(String var1, T var2) throws IOException;

    public <T extends Entity> void update(String var1, T var2) throws IOException;

    public <T extends Entity> T get(String var1, String var2);

    public <T extends Entity> T get(String var1, String var2, String var3);

    public String executeRaw(String var1, String var2, String var3) throws IOException;

    public boolean tag(Project var1, String var2, String var3, Tag ... var4) throws IOException;

    public boolean untag(Project var1, String var2, String var3, Tag ... var4) throws IOException;

    public boolean tag(Project var1, List<String> var2, Tag ... var3) throws IOException;

    public boolean untag(Project var1, List<String> var2, Tag ... var3) throws IOException;

    public ExtractedText getExtractedText(String var1, String var2, String var3, int var4, int var5, String var6) throws IOException;

    public SearchedText searchTextOccurrences(String var1, String var2, String var3, String var4) throws IOException;

    public SearchedText searchTextOccurrences(String var1, String var2, String var3, String var4, String var5) throws IOException;

    public static interface Searcher {
        public Searcher ofStatus(Document.Status var1);

        public Stream<? extends Entity> execute() throws IOException;

        public Stream<? extends Entity> scroll() throws IOException;

        public Stream<? extends Entity> scroll(int var1, int var2) throws IOException;

        public Searcher set(JsonNode var1);

        public Searcher setFromTemplate(String var1, String var2, int var3, boolean var4);

        public Searcher withSource(String ... var1);

        public Searcher withoutSource(String ... var1);

        public Searcher withSource(boolean var1);

        public Searcher without(Pipeline.Type ... var1);

        public Searcher with(Pipeline.Type ... var1);

        public Searcher limit(int var1);

        public void clearScroll() throws IOException;

        public long totalHits();

        public Searcher with(Tag ... var1);

        public Searcher with(String var1);

        public Searcher with(String var1, int var2, boolean var3);

        public Searcher thatMatchesFieldValue(String var1, Object var2);

        public Searcher withFieldValues(String var1, String ... var2);

        public Searcher withPrefixQuery(String var1, String ... var2);
    }
}

