/*
 * Decompiled with CFR 0.152.
 */
package org.icij.datashare.text;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.icij.datashare.Entity;

public class ProjectProxy
implements Entity {
    private static final long serialVersionUID = 6220480617838134179L;
    public final String name;

    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    public ProjectProxy(@JsonProperty(value="name") String name) {
        this.name = name;
    }

    @Override
    public String getId() {
        return this.name;
    }

    public static ProjectProxy proxy(String projectName) {
        return new ProjectProxy(projectName);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProjectProxy project = (ProjectProxy)o;
        return this.name.equals(project.name);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    public static List<String> asNameList(List<ProjectProxy> projects) {
        return projects.stream().map(ProjectProxy::getId).collect(Collectors.toList());
    }

    public static List<ProjectProxy> fromNameStringList(List<String> projects) {
        return projects.stream().map(ProjectProxy::proxy).collect(Collectors.toList());
    }

    public static String[] asNameArray(List<ProjectProxy> projects) {
        return ProjectProxy.asNameList(projects).toArray(new String[0]);
    }

    public static String asCommaConcatNames(List<ProjectProxy> projects) {
        return projects.stream().map(ProjectProxy::getId).collect(Collectors.joining(", "));
    }
}

