/*
 * Decompiled with CFR 0.152.
 */
package org.icij.datashare.batch;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Closeable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.icij.datashare.batch.BatchSearch;
import org.icij.datashare.batch.BatchSearchRecord;
import org.icij.datashare.batch.SearchException;
import org.icij.datashare.batch.SearchResult;
import org.icij.datashare.batch.WebQueryPagination;
import org.icij.datashare.text.Document;
import org.icij.datashare.text.ProjectProxy;
import org.icij.datashare.user.User;

public interface BatchSearchRepository
extends Closeable {
    public boolean save(BatchSearch var1);

    public boolean saveResults(String var1, String var2, List<Document> var3);

    public boolean setState(String var1, BatchSearchRecord.State var2);

    public boolean setState(String var1, SearchException var2);

    public boolean deleteAll(User var1);

    public boolean delete(User var1, String var2);

    public List<BatchSearchRecord> getRecords(User var1, List<String> var2);

    public int getTotal(User var1, List<String> var2, WebQuery var3);

    public List<BatchSearchRecord> getRecords(User var1, List<String> var2, WebQuery var3);

    public List<String> getQueued();

    public List<SearchResult> getResults(User var1, String var2);

    public List<SearchResult> getResults(User var1, String var2, WebQuery var3);

    public int getResultsTotal(User var1, String var2, WebQuery var3);

    public boolean publish(User var1, String var2, boolean var3);

    public BatchSearch get(String var1);

    public BatchSearch get(User var1, String var2);

    public BatchSearch get(User var1, String var2, boolean var3);

    public Map<String, Integer> getQueries(User var1, String var2, int var3, int var4, String var5, String var6);

    public Map<String, Integer> getQueries(User var1, String var2, int var3, int var4, String var5, String var6, int var7);

    public boolean reset(String var1);

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class WebQuery
    extends WebQueryPagination {
        public static final String DEFAULT_SORT_FIELD = "doc_nb";
        public final String query;
        public final String field;
        public final List<String> queries;
        public final boolean queriesExcluded;
        public final List<String> contentTypes;
        public final List<ProjectProxy> project;
        public final List<String> batchDate;
        public final List<String> state;
        public final String publishState;
        public final boolean withQueries;

        @JsonCreator
        public WebQuery(@JsonProperty(value="size") int size, @JsonProperty(value="from") int from, @JsonProperty(value="sort") String sort, @JsonProperty(value="order") String order, @JsonProperty(value="query") String query, @JsonProperty(value="field") String field, @JsonProperty(value="queries") List<String> queries, @JsonProperty(value="project") List<String> project, @JsonProperty(value="batchDate") List<String> batchDate, @JsonProperty(value="state") List<String> state, @JsonProperty(value="publishState") String publishState, @JsonProperty(value="withQueries") boolean withQueries, @JsonProperty(value="queriesExcluded") boolean queriesExcluded, @JsonProperty(value="contentTypes") List<String> contentTypes) {
            super(sort == null ? DEFAULT_SORT_FIELD : sort, sort == null ? "asc" : order, from, size);
            this.query = query;
            this.field = field;
            this.queries = queries == null ? null : Collections.unmodifiableList(queries);
            this.queriesExcluded = queriesExcluded;
            this.contentTypes = contentTypes == null ? null : Collections.unmodifiableList(contentTypes);
            this.project = project == null ? null : Collections.unmodifiableList(ProjectProxy.fromNameStringList(project));
            this.batchDate = batchDate == null ? null : Collections.unmodifiableList(batchDate);
            this.state = state == null ? null : Collections.unmodifiableList(state);
            this.publishState = publishState;
            this.withQueries = withQueries;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            WebQuery that = (WebQuery)o;
            return this.from == that.from && this.size == that.size && Objects.equals(this.sort, that.sort) && Objects.equals(this.order, that.order) && Objects.equals(this.query, that.query) && Objects.equals(this.field, that.field) && Objects.equals(this.queries, that.queries) && Objects.equals(this.project, that.project) && Objects.equals(this.batchDate, that.batchDate) && Objects.equals(this.state, that.state) && Objects.equals(this.publishState, that.publishState) && Objects.equals(this.contentTypes, that.contentTypes) && Objects.equals(this.queriesExcluded, that.queriesExcluded);
        }

        public int hashCode() {
            return Objects.hash(this.sort, this.order, this.query, this.field, this.from, this.size, this.queries, this.project, this.batchDate, this.state, this.publishState, this.contentTypes, this.queriesExcluded);
        }

        public boolean hasFilteredContentTypes() {
            return this.contentTypes != null && !this.contentTypes.isEmpty();
        }

        public boolean hasFilteredQueries() {
            return this.queries != null && !this.queries.isEmpty();
        }

        public boolean hasFilteredProjects() {
            return this.project != null && !this.project.isEmpty();
        }

        public boolean hasFilteredDates() {
            return this.batchDate != null && !this.batchDate.isEmpty();
        }

        public boolean hasFilteredStates() {
            return this.state != null && !this.state.isEmpty();
        }

        public boolean hasFilteredPublishStates() {
            return this.publishState != null && !this.publishState.isEmpty();
        }

        public boolean isSorted() {
            return !DEFAULT_SORT_FIELD.equals(this.sort);
        }
    }
}

