/*
 * Decompiled with CFR 0.152.
 */
package org.icij.datashare.batch;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import org.icij.datashare.text.ProjectProxy;
import org.icij.datashare.user.User;

public class BatchSearchRecord {
    public final String uuid;
    public final boolean published;
    public final List<ProjectProxy> projects;
    public final String name;
    public final String description;
    public final User user;
    public final State state;
    public final Date date;
    public final int nbQueries;
    public final int nbResults;
    public final String errorMessage;
    public final String errorQuery;

    public BatchSearchRecord(List<ProjectProxy> projects, String name, String description, int nbQueries, Date date) {
        this(UUID.randomUUID().toString(), projects, name, description, nbQueries, date, State.QUEUED, User.local(), 0, false, null, null);
    }

    public BatchSearchRecord(String uuid, List<ProjectProxy> projects, String name, String description, int nbQueries, Date date, State state, User user, int nbResults, boolean published, String errorMessage, String errorQuery) {
        assert (date != null && uuid != null);
        this.uuid = uuid;
        this.published = published;
        this.projects = Collections.unmodifiableList(Optional.ofNullable(projects).orElse(new ArrayList()));
        this.name = name;
        this.description = description;
        this.user = user;
        this.date = date;
        this.nbResults = nbResults;
        this.nbQueries = nbQueries;
        this.state = state;
        this.errorMessage = errorMessage;
        this.errorQuery = errorQuery;
    }

    public String toString() {
        return "BatchSearchSummary{" + this.uuid + " name='" + this.name + "' (" + this.state + ")}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BatchSearchRecord that = (BatchSearchRecord)o;
        return this.uuid.equals(that.uuid);
    }

    public int hashCode() {
        return Objects.hash(this.uuid);
    }

    public static enum State {
        QUEUED,
        RUNNING,
        SUCCESS,
        FAILURE;

    }
}

