/*
 * Decompiled with CFR 0.152.
 */
package org.icij.datashare.user;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.icij.datashare.Entity;
import org.icij.datashare.json.JsonUtils;
import org.icij.datashare.text.Project;

public class User
implements Entity {
    public static final String LOCAL = "local";
    public static final String XEMX_APPLICATIONS_KEY = "groups_by_applications";
    public static final String XEMX_DATASHARE_KEY = "datashare";
    public final String id;
    public final String name;
    public final String email;
    public final String provider;
    public final Map<String, Object> details;
    private final HashSet<Project> projects = new HashSet();

    public User(String id, String name, String email, String provider, String jsonDetails) {
        this.id = id;
        this.name = name;
        this.email = email;
        this.provider = provider;
        this.details = Collections.unmodifiableMap(JsonUtils.deserialize(jsonDetails));
    }

    @JsonCreator
    public User(@JsonProperty(value="id") String id, @JsonProperty(value="name") String name, @JsonProperty(value="email") String email, @JsonProperty(value="provider") String provider, @JsonProperty(value="details") Map<String, Object> details) {
        this.id = id;
        this.name = name;
        this.email = email;
        this.provider = provider;
        this.details = Collections.unmodifiableMap(details);
    }

    public User(String id, String name, String email, String provider) {
        this(id, name, email, provider, new HashMap<String, Object>());
    }

    public User(String id, String name, String email) {
        this(id, name, email, LOCAL);
    }

    public User(String id) {
        this(id, null, null, LOCAL);
    }

    public User(Map<String, Object> map) {
        this((String)map.get("uid"), (String)map.get("name"), (String)map.get("email"), (String)map.getOrDefault("provider", LOCAL), map);
    }

    public User(User user) {
        this(Optional.ofNullable(user).orElse((User)User.nullUser()).id, Optional.ofNullable(user).orElse((User)User.nullUser()).name, Optional.ofNullable(user).orElse((User)User.nullUser()).email, Optional.ofNullable(user).orElse((User)User.nullUser()).provider, Optional.ofNullable(user).orElse((User)User.nullUser()).details);
    }

    public static User fromJson(String json, String provider) {
        if (json == null) {
            return null;
        }
        Map<String, Object> hashMap = JsonUtils.deserialize(json);
        hashMap.put("provider", provider);
        return new User(hashMap);
    }

    @JsonIgnore
    public List<String> getApplicationProjectNames() {
        HashMap applications = Optional.ofNullable(this.details.get(XEMX_APPLICATIONS_KEY)).orElse(new HashMap());
        return Optional.ofNullable(applications.get(XEMX_DATASHARE_KEY)).orElse(new LinkedList());
    }

    @JsonIgnore
    public List<Project> getApplicationProjects() {
        return this.getApplicationProjectNames().stream().map(Project::new).collect(Collectors.toList());
    }

    @JsonIgnore
    public List<String> getProjectNames() {
        return this.getProjects().stream().map(p -> p.name).collect(Collectors.toList());
    }

    @JsonIgnore
    public List<Project> getProjects() {
        HashSet<Project> uniqueProjects = new HashSet<Project>(this.projects);
        uniqueProjects.addAll(this.getApplicationProjects());
        return new ArrayList<Project>(uniqueProjects);
    }

    @JsonIgnore
    public User addProject(String newProjectName) {
        Project newProject = new Project(newProjectName);
        return this.addProject(newProject);
    }

    @JsonIgnore
    public User addProject(Project newProject) {
        if (!this.getProjects().contains(newProject)) {
            this.projects.add(newProject);
        }
        return this;
    }

    @JsonIgnore
    public User addProjectNames(List<String> newProjectNames) {
        newProjectNames.forEach(this::addProject);
        return this;
    }

    @JsonIgnore
    public User addProjects(List<Project> newProjects) {
        newProjects.forEach(this::addProject);
        return this;
    }

    @JsonIgnore
    public User setProjectNames(List<String> newProjectNames) {
        return this.clearProjects().addProjectNames(newProjectNames);
    }

    @JsonIgnore
    public User setProjects(List<Project> newProjects) {
        return this.clearProjects().addProjects(newProjects);
    }

    @JsonIgnore
    public User clearProjects() {
        this.projects.clear();
        return this;
    }

    @JsonIgnore
    public Map<String, Object> getDetails() {
        return this.details.entrySet().stream().filter(k -> k.getValue() != null).filter(k -> !((String)k.getKey()).equalsIgnoreCase("password")).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    @JsonIgnore
    public String getJsonDetails() {
        return JsonUtils.serialize(this.getDetails());
    }

    public boolean isGranted(String projectName) {
        return this.getProjectNames().contains(projectName);
    }

    public boolean isGranted(Project project) {
        return this.getProjects().contains(project);
    }

    @Override
    public String getId() {
        return this.id;
    }

    public String queueName() {
        return "extract:queue_" + this.id;
    }

    @JsonIgnore
    public String getPath() {
        return this.equals(User.local()) || this.isNull() ? "" : this.id;
    }

    @JsonIgnore
    public boolean isNull() {
        return this.id == null;
    }

    @JsonIgnore
    public boolean isLocal() {
        return LOCAL.equals(this.id);
    }

    public static User local() {
        return User.localUser(LOCAL);
    }

    public static User localUser(final String id) {
        return new User((Map<String, Object>)new HashMap<String, Object>(){
            {
                this.put("uid", id);
                this.put(User.XEMX_APPLICATIONS_KEY, new HashMap<String, Object>(){
                    {
                        this.put(User.XEMX_DATASHARE_KEY, Collections.singletonList(id + "-datashare"));
                    }
                });
            }
        });
    }

    public static User nullUser() {
        return new User((String)null);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof User)) {
            return false;
        }
        User user = (User)o;
        return Objects.equals(this.id, user.id);
    }
}

