/*
 * Decompiled with CFR 0.152.
 */
package org.icij.datashare.text.nlp;

import java.io.IOException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import org.icij.datashare.DynamicClassLoader;
import org.icij.datashare.io.RemoteFiles;
import org.icij.datashare.text.Language;
import org.icij.datashare.text.nlp.NlpStage;
import org.icij.datashare.text.nlp.Pipeline;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractModels<T> {
    public static final String JVM_PROPERTY_NAME = "DS_SYNC_NLP_MODELS";
    protected final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private static final Path BASE_DIR = Paths.get(".", new String[0]).toAbsolutePath().normalize();
    protected static final Path BASE_CLASSPATH = Paths.get("models", new String[0]);
    private static final String PREFIX = "dist";
    protected final ConcurrentHashMap<Language, Semaphore> modelLock = new ConcurrentHashMap<Language, Semaphore>(){
        {
            for (Language l : Language.values()) {
                this.put(l, new Semaphore(1, true));
            }
        }
    };
    public final NlpStage stage;
    protected final Map<Language, T> models;
    protected final Pipeline.Type type;

    protected AbstractModels(Pipeline.Type type, NlpStage stage) {
        this.stage = stage;
        this.type = type;
        this.models = new HashMap<Language, T>();
    }

    protected abstract T loadModelFile(Language var1) throws IOException;

    protected abstract String getVersion();

    public T get(Language language) throws InterruptedException {
        if (!this.isLoaded(language)) {
            this.load(language);
        }
        return this.models.get(language);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load(Language language) throws InterruptedException {
        Semaphore l = this.modelLock.get(language);
        l.acquire();
        try {
            if (this.isLoaded(language)) {
                return;
            }
            if (AbstractModels.isSync()) {
                this.downloadIfNecessary(language);
            }
            this.models.put(language, this.loadModelFile(language));
            this.LOGGER.info("loaded {} model for {}", (Object)this.stage, (Object)language);
        }
        catch (IOException e) {
            this.LOGGER.error("failed loading " + this.stage, (Throwable)e);
        }
        finally {
            l.release();
        }
    }

    public Path getModelsBasePath(Language language) {
        return BASE_CLASSPATH.resolve(this.type.name().toLowerCase()).resolve(this.getVersion().replace('.', '-')).resolve(language.iso6391Code());
    }

    public Path getModelsFilesystemPath(Language language) {
        return Paths.get(PREFIX, new String[0]).resolve(this.getModelsBasePath(language));
    }

    public void addResourceToContextClassLoader(Path resourcePath) {
        DynamicClassLoader classLoader = (DynamicClassLoader)ClassLoader.getSystemClassLoader();
        URL resource = classLoader.getResource(resourcePath.toString());
        this.LOGGER.info("adding {} to system classloader", (Object)(resource == null ? null : resource.getPath()));
        classLoader.add(resource);
    }

    protected boolean isPresent(Language language) {
        return Thread.currentThread().getContextClassLoader().getResource(this.getModelsBasePath(language).toString()) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void downloadIfNecessary(Language language) {
        String remoteKey = this.getModelsFilesystemPath(language).toString().replace("\\", "/");
        RemoteFiles remoteFiles = this.getRemoteFiles();
        try {
            if (this.isPresent(language) && remoteFiles.isSync(remoteKey, BASE_DIR.toFile())) {
                return;
            }
            this.LOGGER.info("downloading models for language {} under {}", (Object)language, (Object)remoteKey);
            remoteFiles.download(remoteKey, BASE_DIR.toFile());
            this.LOGGER.info("models successfully downloaded for language {}", (Object)language);
        }
        catch (IOException | InterruptedException e) {
            this.LOGGER.error("failed downloading models for " + language, (Throwable)e);
        }
        finally {
            remoteFiles.shutdown();
        }
    }

    public void unload(Language language) throws InterruptedException {
        Semaphore l = this.modelLock.get(language);
        l.acquire();
        try {
            this.models.remove(language);
        }
        finally {
            l.release();
        }
    }

    public static void syncModels(boolean sync) {
        LoggerFactory.getLogger(AbstractModels.class).info("synchronize models is set to {}", (Object)sync);
        System.setProperty(JVM_PROPERTY_NAME, String.valueOf(sync));
    }

    public static boolean isSync() {
        return Boolean.parseBoolean(System.getProperty(JVM_PROPERTY_NAME, "true"));
    }

    public boolean isLoaded(Language language) {
        return this.models.containsKey(language);
    }

    protected RemoteFiles getRemoteFiles() {
        return RemoteFiles.getDefault();
    }
}

