/*
 * Decompiled with CFR 0.152.
 */
package org.icij.datashare.text;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import me.xuender.unidecode.Unidecode;
import org.icij.datashare.Entity;
import org.icij.datashare.function.ThrowingFunction;
import org.icij.datashare.function.ThrowingFunctions;
import org.icij.datashare.text.Language;
import org.icij.datashare.text.indexing.IndexId;
import org.icij.datashare.text.indexing.IndexParent;
import org.icij.datashare.text.indexing.IndexRoot;
import org.icij.datashare.text.indexing.IndexType;
import org.icij.datashare.text.nlp.Annotations;
import org.icij.datashare.text.nlp.NlpStage;
import org.icij.datashare.text.nlp.NlpTag;
import org.icij.datashare.text.nlp.Pipeline;

@IndexType(value="NamedEntity")
@JsonIgnoreProperties(ignoreUnknown=true)
public final class NamedEntity
implements Entity {
    private static final long serialVersionUID = 1946532866377498L;
    private final String mention;
    private final String mentionNorm;
    @IndexId
    @JsonIgnore
    private final String id;
    private final Category category;
    @IndexParent
    @JsonIgnore
    private final String documentId;
    @IndexRoot
    @JsonIgnore
    private final String rootDocument;
    private final List<Long> offsets = new LinkedList<Long>();
    private final Pipeline.Type extractor;
    private final Language extractorLanguage;
    private final String partsOfSpeech;
    private final Map<String, Object> metadata;
    private Boolean hidden;

    public static NamedEntity create(Category cat, String mention, List<Long> offsets, String doc, String rootDocument, Pipeline.Type extr, Language extrLang) {
        return new NamedEntity(cat, mention, offsets, doc, rootDocument, extr, extrLang, false, null, null);
    }

    public static NamedEntity create(Category cat, String mention, List<Long> offsets, String doc, String rootDocument, Pipeline.Type extr, Language extrLang, Map<String, Object> metadata) {
        return new NamedEntity(cat, mention, offsets, doc, rootDocument, extr, extrLang, false, null, metadata);
    }

    public static List<NamedEntity> allFrom(String text, Annotations annotations) {
        return annotations.get(NlpStage.NER).stream().map(tag -> NamedEntity.from(text, tag, annotations)).filter(ne -> ne.category != Category.UNKNOWN).collect(Collectors.toList());
    }

    public static NamedEntity from(String text, NlpTag tag, Annotations annotations) {
        String mention = ThrowingFunctions.removeNewLines.apply(text.substring(tag.getBegin(), tag.getEnd()));
        List<NlpTag> posTags = annotations.get(NlpStage.POS);
        int posTagIndex = Collections.binarySearch(posTags, tag, NlpTag.comparator);
        if (posTagIndex > 0) {
            LOGGER.info(posTagIndex + ", " + posTags.get(posTagIndex));
        }
        return NamedEntity.create(tag.getCategory(), mention, Arrays.asList(tag.getBegin()), annotations.documentId, annotations.rootId, annotations.pipelineType, annotations.language);
    }

    @JsonCreator
    private NamedEntity(@JsonProperty(value="category") Category category, @JsonProperty(value="mention") String mention, @JsonProperty(value="offsets") List<Long> offsets, @JsonProperty(value="documentId") String documentId, @JsonProperty(value="rootDocument") String rootDocument, @JsonProperty(value="extractor") Pipeline.Type extractor, @JsonProperty(value="extractorLanguage") Language extractorLanguage, @JsonProperty(value="isHidden") Boolean hidden, @JsonProperty(value="partOfSpeech") String partsOfSpeech, @JsonProperty(value="metadata") Map<String, Object> metadata) {
        if (mention == null || mention.isEmpty()) {
            throw new IllegalArgumentException("Mention is undefined");
        }
        this.mentionNorm = NamedEntity.normalize(mention);
        this.id = HASHER.hash(String.join((CharSequence)"|", documentId, String.valueOf(offsets), extractor.toString(), this.mentionNorm));
        this.category = Optional.ofNullable(category).orElse(Category.UNKNOWN);
        this.mention = mention;
        this.documentId = documentId;
        this.rootDocument = rootDocument;
        this.offsets.addAll(offsets);
        this.extractor = extractor;
        this.extractorLanguage = extractorLanguage;
        this.hidden = hidden;
        this.partsOfSpeech = partsOfSpeech;
        this.metadata = metadata;
    }

    @Override
    @JsonIgnore
    public String getId() {
        return this.id;
    }

    public String getMention() {
        return this.mention;
    }

    public Category getCategory() {
        return this.category;
    }

    @JsonIgnore
    public String getDocumentId() {
        return this.documentId;
    }

    @JsonIgnore
    public String getRootDocument() {
        return this.rootDocument;
    }

    public int getMentionNormTextLength() {
        return this.mentionNorm.length();
    }

    public List<Long> getOffsets() {
        return this.offsets;
    }

    public Pipeline.Type getExtractor() {
        return this.extractor;
    }

    public Language getExtractorLanguage() {
        return this.extractorLanguage;
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    @JsonGetter(value="isHidden")
    public Boolean isHidden() {
        return this.hidden;
    }

    public NamedEntity hide() {
        this.hidden = true;
        return this;
    }

    public NamedEntity unhide() {
        this.hidden = false;
        return this;
    }

    public String getPartsOfSpeech() {
        return this.partsOfSpeech;
    }

    public String toString() {
        return "NamedEntity{mention='" + this.mention + "', id='" + this.id + "', category=" + this.category + ", offsets=" + this.offsets + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NamedEntity that = (NamedEntity)o;
        return this.id.equals(that.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    @JsonIgnore
    public static String normalize(String unicoded) {
        return Unidecode.decode((String)unicoded).trim().replaceAll("(\\s+)", " ").toLowerCase();
    }

    public static enum Category implements Serializable
    {
        PERSON("PERS"),
        ORGANIZATION("ORG"),
        LOCATION("LOC"),
        EMAIL("MAIL"),
        DATE("DATE"),
        MONEY("MON"),
        NUMBER("NUM"),
        NONE("NONE"),
        UNKNOWN("UNK");

        private static final long serialVersionUID = -1596432856473673L;
        private final String abbreviation;
        public static ThrowingFunction<List<String>, List<Category>> parseAll;

        private Category(String abbrev) {
            this.abbreviation = abbrev;
        }

        public String getAbbreviation() {
            return this.abbreviation;
        }

        public static Category parse(String entityCategory) {
            if (entityCategory == null || entityCategory.isEmpty() || entityCategory.trim().equals("0") || entityCategory.trim().equals("O")) {
                return NONE;
            }
            try {
                return Category.valueOf(entityCategory.toUpperCase(Locale.ROOT));
            }
            catch (IllegalArgumentException e) {
                String normEntityCategory = ThrowingFunctions.removePattFrom.apply("^I-").apply(entityCategory);
                for (Category cat : Category.values()) {
                    String catAbbreviation = cat.getAbbreviation();
                    if (!normEntityCategory.equalsIgnoreCase(catAbbreviation) && !normEntityCategory.equalsIgnoreCase(catAbbreviation.substring(0, Math.min(catAbbreviation.length(), 3)))) continue;
                    return cat;
                }
                return UNKNOWN;
            }
        }

        static {
            parseAll = list -> list.stream().map(Category::parse).filter(cat -> cat != UNKNOWN).collect(Collectors.toList());
        }
    }
}

