/*
 * Decompiled with CFR 0.152.
 */
package org.iartisan.admin.template.controller.support;

import org.iartisan.admin.template.authentication.support.service.RoleSupportService;
import org.iartisan.admin.template.authentication.support.service.UserSupportService;
import org.iartisan.admin.template.authentication.support.service.entity.UserEntity;
import org.iartisan.runtime.bean.Page;
import org.iartisan.runtime.bean.PageWrapper;
import org.iartisan.runtime.web.WebR;
import org.iartisan.runtime.web.controller.BaseController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"userSupport"})
public class UserSupportController
extends BaseController {
    private static final String VIEW_PREFIX = "user/";
    @Autowired
    private UserSupportService userSupportService;
    @Autowired
    private RoleSupportService roleSupportService;

    @GetMapping(value={"/index"})
    public String index() {
        return "user/user_index";
    }

    @ResponseBody
    @PostMapping(value={"queryPageData"})
    public WebR queryPageData(Page page, String userName) {
        PageWrapper<UserEntity> pageData = this.userSupportService.getUserPageData(page, userName);
        WebR webR = new WebR(pageData.getPage());
        webR.setDataList(pageData.getDataList());
        return webR;
    }

    @GetMapping(value={"modifyDataDialog"})
    public String modifyDataDialog(String userId, Model model) {
        model.addAttribute("data", (Object)this.roleSupportService.getRoleByUserId(userId));
        return "user/user_modify";
    }

    @GetMapping(value={"addDataDialog"})
    public String addDataDialog(Model model) {
        model.addAttribute("data", this.roleSupportService.getAllRoles());
        return "user/user_add";
    }

    @ResponseBody
    @PostMapping(value={"addData"})
    public WebR addData(UserEntity entity) {
        this.userSupportService.addUser(entity);
        WebR r = new WebR();
        return r;
    }

    @ResponseBody
    @PostMapping(value={"modifyData"})
    public WebR modifyData(UserEntity entity) {
        this.userSupportService.modifyData(entity);
        WebR r = new WebR();
        return r;
    }

    @ResponseBody
    @PostMapping(value={"changeStatus"})
    public WebR changeStatus(String userId, String status) {
        this.userSupportService.changeStatus(userId, status);
        WebR r = new WebR();
        return r;
    }

    @ResponseBody
    @PostMapping(value={"deleteData"})
    public WebR deleteData(String userId) {
        this.userSupportService.deleteByUserId(userId);
        WebR r = new WebR();
        return r;
    }
}

