/*
 * Decompiled with CFR 0.152.
 */
package org.iartisan.admin.template.controller.support;

import org.iartisan.admin.template.authentication.support.service.MenuSupportService;
import org.iartisan.admin.template.authentication.support.service.entity.MenuEntity;
import org.iartisan.runtime.bean.Page;
import org.iartisan.runtime.bean.PageWrapper;
import org.iartisan.runtime.web.WebR;
import org.iartisan.runtime.web.authentication.MenuTree;
import org.iartisan.runtime.web.controller.BaseController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"menuSupport"})
public class MenuSupportController
extends BaseController {
    private static final String VIEW_PREFIX = "menu/";
    @Autowired
    private MenuSupportService menuSupportService;

    @GetMapping(value={"/index"})
    public String index() {
        return "menu/menu_index";
    }

    @GetMapping(value={"addDataDialog"})
    public String addDataDialog(Model model) {
        model.addAttribute("data", this.menuSupportService.getFirstMenus());
        return "menu/menu_add";
    }

    @ResponseBody
    @PostMapping(value={"queryPageData"})
    public WebR queryPageData(Page page, String menuName) {
        PageWrapper<MenuTree> pageData = this.menuSupportService.getMenuPageData(page, menuName);
        WebR webR = new WebR(pageData.getPage());
        webR.setDataList(pageData.getDataList());
        return webR;
    }

    @ResponseBody
    @PostMapping(value={"addData"})
    public WebR addData(MenuEntity menuEntity) {
        this.menuSupportService.addMenu(menuEntity);
        WebR webR = new WebR();
        return webR;
    }

    @ResponseBody
    @PostMapping(value={"deleteData"})
    public WebR deleteData(String menuId) {
        this.menuSupportService.deleteData(menuId);
        WebR webR = new WebR();
        return webR;
    }

    @GetMapping(value={"modifyDataDialog"})
    public String modifyDataDialog(Model model, String menuId) {
        model.addAttribute("firstMenus", this.menuSupportService.getFirstMenus());
        model.addAttribute("data", (Object)this.menuSupportService.getMenuById(menuId));
        return "menu/menu_modify";
    }

    @ResponseBody
    @PostMapping(value={"modifyData"})
    public WebR modifyData(MenuEntity menuEntity) {
        this.menuSupportService.modifyData(menuEntity);
        WebR webR = new WebR();
        return webR;
    }
}

