/*
 * Decompiled with CFR 0.152.
 */
package org.iartisan.admin.template.authentication.support.service;

import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.baomidou.mybatisplus.mapper.Wrapper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.iartisan.admin.template.authentication.support.dbm.mapper.SystemMenuMapper;
import org.iartisan.admin.template.authentication.support.dbm.mapper.SystemRolePermissionMapper;
import org.iartisan.admin.template.authentication.support.dbm.mapper.SystemUserMapper;
import org.iartisan.admin.template.authentication.support.dbm.mapper.SystemUserRoleMapper;
import org.iartisan.admin.template.authentication.support.dbm.model.SystemMenuDO;
import org.iartisan.admin.template.authentication.support.dbm.model.SystemRolePermissionDO;
import org.iartisan.admin.template.authentication.support.dbm.model.SystemUserDO;
import org.iartisan.admin.template.authentication.support.dbm.model.SystemUserRoleDO;
import org.iartisan.admin.template.authentication.support.service.RoleSupportService;
import org.iartisan.admin.template.authentication.support.service.entity.UserEntity;
import org.iartisan.runtime.bean.Page;
import org.iartisan.runtime.bean.PageWrapper;
import org.iartisan.runtime.jdbc.MybatisBaseMapper;
import org.iartisan.runtime.jdbc.PageHelper;
import org.iartisan.runtime.utils.StringUtils;
import org.iartisan.runtime.utils.UUIDUtil;
import org.iartisan.runtime.web.authentication.MenuTree;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserSupportService {
    @Autowired
    private SystemUserMapper systemUserMapper;
    @Autowired
    private SystemRolePermissionMapper systemRolePermissionMapper;
    @Autowired
    private SystemMenuMapper systemMenuMapper;
    @Autowired
    private SystemUserRoleMapper systemUserRoleMapper;
    @Autowired
    private RoleSupportService roleSupportService;

    public SystemUserDO login(String userName, String userPwd) {
        SystemUserDO dbQuery = new SystemUserDO();
        dbQuery.setUserName(userName);
        dbQuery.setUserPwd(userPwd.toLowerCase());
        return (SystemUserDO)this.systemUserMapper.selectOne(dbQuery);
    }

    public List<MenuTree> getMenus(String userId) {
        List<String> roles = this.roleSupportService.getRoleIdsByUserId(userId);
        if (null == roles) {
            return null;
        }
        SystemRolePermissionDO dbQuery = new SystemRolePermissionDO();
        dbQuery.setRoleIds(roles);
        List<String> menuIds = this.systemRolePermissionMapper.selectPermissions(dbQuery);
        SystemMenuDO systemMenuDO = new SystemMenuDO();
        systemMenuDO.setMenuIds(menuIds);
        List<SystemMenuDO> firstMenus = this.systemMenuMapper.selectFirstMenus(systemMenuDO);
        if (firstMenus == null) {
            return null;
        }
        ArrayList<MenuTree> result = new ArrayList<MenuTree>();
        for (SystemMenuDO firstMenu : firstMenus) {
            MenuTree firstTree = new MenuTree();
            firstTree.setTitle(firstMenu.getMenuName());
            firstTree.setIcon(firstMenu.getMenuIcon());
            firstTree.setHref(firstMenu.getMenuUrl());
            SystemMenuDO secondQuery = new SystemMenuDO();
            secondQuery.setMenuIds(menuIds);
            secondQuery.setParentMenuId(firstMenu.getMenuId());
            List<SystemMenuDO> secondMenus = this.systemMenuMapper.selectSecondMenus(secondQuery);
            if (null != secondMenus) {
                ArrayList<MenuTree> children = new ArrayList<MenuTree>();
                for (SystemMenuDO secondMenu : secondMenus) {
                    MenuTree secondTree = new MenuTree();
                    secondTree.setTitle(secondMenu.getMenuName());
                    secondTree.setIcon(secondMenu.getMenuIcon());
                    secondTree.setHref(secondMenu.getMenuUrl());
                    children.add(secondTree);
                }
                firstTree.setChildren(children);
            }
            result.add(firstTree);
        }
        return result;
    }

    public PageWrapper<UserEntity> getUserPageData(Page page, String userName) {
        SystemUserDO userDO = new SystemUserDO();
        if (StringUtils.isNotEmpty((String)userName)) {
            userDO.setUserName(userName);
        }
        PageWrapper dbResult = PageHelper.getPageData((MybatisBaseMapper)this.systemUserMapper, (Page)page, (Object)userDO);
        PageWrapper result = new PageWrapper(dbResult.getPage());
        ArrayList<UserEntity> pageList = new ArrayList<UserEntity>();
        for (SystemUserDO o : dbResult.getDataList()) {
            UserEntity bean = new UserEntity();
            bean.setUserName(o.getUserName());
            bean.setUserId(o.getUserId());
            bean.setUserStatus(o.getStatus());
            bean.setCreateDate(o.getCreateTime());
            pageList.add(bean);
        }
        result.setDataList(pageList);
        return result;
    }

    public void addUser(UserEntity userEntity) {
        SystemUserDO dbInsert = new SystemUserDO();
        String userId = UUIDUtil.timeBaseId();
        dbInsert.setUserId(userId);
        dbInsert.setUserName(userEntity.getUserName());
        dbInsert.setStatus(userEntity.getUserStatus());
        dbInsert.setCreateTime(new Date());
        dbInsert.setUserPwd("123456");
        try {
            this.systemUserMapper.insert(dbInsert);
            this.addRole(userId, userEntity.getRoles());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void changeStatus(String userId, String status) {
        SystemUserDO dbModify = new SystemUserDO();
        dbModify.setUserId(userId);
        dbModify.setStatus(status);
        dbModify.setCreateTime(new Date());
        this.systemUserMapper.updateById(dbModify);
    }

    public void modifyData(UserEntity userEntity) {
        SystemUserRoleDO entity = new SystemUserRoleDO();
        entity.setUserId(userEntity.getUserId());
        EntityWrapper dbDel = new EntityWrapper((Object)entity);
        this.systemUserRoleMapper.delete((Wrapper)dbDel);
        this.addRole(userEntity.getUserId(), userEntity.getRoles());
    }

    private void addRole(String userId, String roleStr) {
        String[] roles;
        for (String role : roles = roleStr.split(",")) {
            SystemUserRoleDO db = new SystemUserRoleDO();
            db.setUserId(userId);
            db.setRoleId(role);
            db.setCreateTime(new Date());
            this.systemUserRoleMapper.insert(db);
        }
    }

    public void deleteByUserId(String userId) {
        this.systemUserMapper.deleteById((Serializable)((Object)userId));
    }
}

