/*
 * Decompiled with CFR 0.152.
 */
package org.iartisan.admin.template.authentication.support.service;

import com.baomidou.mybatisplus.mapper.Condition;
import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.baomidou.mybatisplus.mapper.Wrapper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.iartisan.admin.template.authentication.support.dbm.mapper.SystemRoleMapper;
import org.iartisan.admin.template.authentication.support.dbm.mapper.SystemRolePermissionMapper;
import org.iartisan.admin.template.authentication.support.dbm.mapper.SystemUserMapper;
import org.iartisan.admin.template.authentication.support.dbm.mapper.SystemUserRoleMapper;
import org.iartisan.admin.template.authentication.support.dbm.model.SystemRoleDO;
import org.iartisan.admin.template.authentication.support.dbm.model.SystemRolePermissionDO;
import org.iartisan.admin.template.authentication.support.dbm.model.SystemUserDO;
import org.iartisan.admin.template.authentication.support.dbm.model.SystemUserRoleDO;
import org.iartisan.admin.template.authentication.support.service.entity.RoleEntity;
import org.iartisan.admin.template.authentication.support.service.entity.UserEntity;
import org.iartisan.admin.template.authentication.support.service.entity.UserRoleEntity;
import org.iartisan.runtime.bean.Page;
import org.iartisan.runtime.bean.PageWrapper;
import org.iartisan.runtime.jdbc.MybatisBaseMapper;
import org.iartisan.runtime.jdbc.PageHelper;
import org.iartisan.runtime.utils.CollectionUtil;
import org.iartisan.runtime.utils.StringUtils;
import org.iartisan.runtime.utils.UUIDUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class RoleSupportService {
    @Autowired
    private SystemRoleMapper systemRoleMapper;
    @Autowired
    private SystemRolePermissionMapper systemRolePermissionMapper;
    @Autowired
    private SystemUserRoleMapper systemUserRoleMapper;
    @Autowired
    private SystemUserMapper systemUserMapper;

    public List<RoleEntity> getAllRoles() {
        List dbRoleResult = this.systemRoleMapper.selectList((Wrapper)Condition.EMPTY);
        ArrayList<RoleEntity> result = new ArrayList<RoleEntity>();
        if (CollectionUtil.isNotEmpty((Collection)dbRoleResult)) {
            for (SystemRoleDO roleDO : dbRoleResult) {
                RoleEntity entity = new RoleEntity();
                entity.setRoleId(roleDO.getRoleId());
                entity.setRoleName(roleDO.getRoleName());
                result.add(entity);
            }
        }
        return result;
    }

    public RoleEntity getAuthDetail(String roleId) {
        SystemRoleDO dbResult = (SystemRoleDO)this.systemRoleMapper.selectById((Serializable)((Object)roleId));
        RoleEntity result = new RoleEntity();
        if (null != dbResult) {
            result.setRoleId(dbResult.getRoleId());
            result.setRoleName(dbResult.getRoleName());
        }
        return result;
    }

    public PageWrapper<RoleEntity> getAuthPageData(Page page, String roleName) {
        SystemRoleDO roleDO = new SystemRoleDO();
        if (StringUtils.isNotEmpty((String)roleName)) {
            roleDO.setRoleName(roleName);
        }
        PageWrapper dbResult = PageHelper.getPageData((MybatisBaseMapper)this.systemRoleMapper, (Page)page, (Object)roleDO);
        PageWrapper result = new PageWrapper(dbResult.getPage());
        ArrayList<RoleEntity> pageList = new ArrayList<RoleEntity>();
        for (SystemRoleDO o : dbResult.getDataList()) {
            RoleEntity bean = new RoleEntity();
            bean.setRoleId(o.getRoleId());
            bean.setRoleName(o.getRoleName());
            bean.setCreateTime(o.getCreateTime());
            pageList.add(bean);
        }
        result.setDataList(pageList);
        return result;
    }

    @Transactional
    public void addRole(RoleEntity roleEntity) {
        SystemRoleDO dbRoleInsert = new SystemRoleDO();
        dbRoleInsert.setRoleName(roleEntity.getRoleName());
        String roleId = UUIDUtil.shortId();
        dbRoleInsert.setRoleId(roleId);
        dbRoleInsert.setCreateTime(new Date());
        this.systemRoleMapper.insert(dbRoleInsert);
        String permissionStr = roleEntity.getPermissions();
        if (StringUtils.isNotEmpty((String)permissionStr)) {
            String[] permissions;
            for (String permission : permissions = permissionStr.split(",")) {
                SystemRolePermissionDO dbPermission = new SystemRolePermissionDO();
                dbPermission.setRoleId(roleId);
                String[] types = permission.split("\\|");
                dbPermission.setPermissionId(types[0]);
                if (types.length < 2) {
                    dbPermission.setPermissionType("m");
                } else {
                    dbPermission.setPermissionType(types[1]);
                }
                dbPermission.setCreateTime(new Date());
                this.systemRolePermissionMapper.insert(dbPermission);
            }
        }
    }

    public List<String> getRoleIdsByUserId(String userId) {
        SystemUserRoleDO systemUserRoleDO = new SystemUserRoleDO();
        systemUserRoleDO.setUserId(userId);
        EntityWrapper query = new EntityWrapper((Object)systemUserRoleDO);
        List dbResult = this.systemUserRoleMapper.selectList((Wrapper)query);
        if (null == dbResult) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        for (SystemUserRoleDO userRoleDO : dbResult) {
            result.add(userRoleDO.getRoleId());
        }
        return result;
    }

    public UserRoleEntity getRoleByUserId(String userId) {
        List<String> userRoleIds = this.getRoleIdsByUserId(userId);
        UserRoleEntity result = new UserRoleEntity();
        List<RoleEntity> dbRoleResult = this.getAllRoles();
        if (CollectionUtil.isNotEmpty(dbRoleResult)) {
            ArrayList<RoleEntity> roleEntities = new ArrayList<RoleEntity>();
            for (RoleEntity roleEntity : dbRoleResult) {
                if (userRoleIds.contains(roleEntity.getRoleId())) {
                    roleEntity.setOwn(true);
                }
                roleEntities.add(roleEntity);
            }
            result.setRoleEntities(roleEntities);
            SystemUserDO userDO = (SystemUserDO)this.systemUserMapper.selectById((Serializable)((Object)userId));
            UserEntity userEntity = new UserEntity();
            userEntity.setUserId(userId);
            userEntity.setUserName(userDO.getUserName());
            result.setUserEntity(userEntity);
        }
        return result;
    }

    public void deleteRole(String roleId) {
        this.systemRoleMapper.deleteById((Serializable)((Object)roleId));
    }
}

