/*
 * Decompiled with CFR 0.152.
 */
package org.iartisan.admin.template.authentication.support.service;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.iartisan.admin.template.authentication.support.dbm.mapper.SystemMenuMapper;
import org.iartisan.admin.template.authentication.support.dbm.model.SystemMenuDO;
import org.iartisan.admin.template.authentication.support.service.entity.MenuEntity;
import org.iartisan.runtime.bean.Page;
import org.iartisan.runtime.bean.PageWrapper;
import org.iartisan.runtime.jdbc.MybatisBaseMapper;
import org.iartisan.runtime.jdbc.PageHelper;
import org.iartisan.runtime.utils.CollectionUtil;
import org.iartisan.runtime.utils.UUIDUtil;
import org.iartisan.runtime.web.authentication.MenuTree;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MenuSupportService {
    @Autowired
    private SystemMenuMapper systemMenuMapper;

    public PageWrapper<MenuTree> getMenuPageData(Page page, String menuName) {
        SystemMenuDO systemMenuDO = new SystemMenuDO();
        systemMenuDO.setMenuName(menuName);
        PageWrapper dbResult = PageHelper.getPageData((MybatisBaseMapper)this.systemMenuMapper, (Page)page, (Object)systemMenuDO);
        PageWrapper result = new PageWrapper(dbResult.getPage());
        ArrayList<MenuTree> pageList = new ArrayList<MenuTree>();
        for (SystemMenuDO menuDO : dbResult.getDataList()) {
            MenuTree tree = new MenuTree();
            tree.setId((Serializable)((Object)menuDO.getMenuId()));
            tree.setTitle(menuDO.getMenuName());
            tree.setHref(menuDO.getMenuUrl());
            tree.setIcon(menuDO.getMenuIcon());
            pageList.add(tree);
        }
        result.setDataList(pageList);
        return result;
    }

    public List<MenuTree> getFirstMenus() {
        List<SystemMenuDO> firstMenuList = this.systemMenuMapper.selectFirstMenus(new SystemMenuDO());
        ArrayList<MenuTree> result = new ArrayList<MenuTree>();
        if (CollectionUtil.isNotEmpty(firstMenuList)) {
            for (SystemMenuDO systemMenuDO : firstMenuList) {
                MenuTree tree = new MenuTree();
                tree.setId((Serializable)((Object)systemMenuDO.getMenuId()));
                tree.setTitle(systemMenuDO.getMenuName());
                result.add(tree);
            }
        }
        return result;
    }

    public void addMenu(MenuEntity menuEntity) {
        SystemMenuDO dbInsert = new SystemMenuDO();
        dbInsert.setMenuId(UUIDUtil.shortId());
        dbInsert.setMenuName(menuEntity.getMenuName());
        dbInsert.setParentMenuId(menuEntity.getParentMenuId());
        dbInsert.setMenuUrl(menuEntity.getMenuUrl());
        dbInsert.setMenuIcon(menuEntity.getMenuIcon());
        dbInsert.setMenuPermission(menuEntity.getMenuPermission());
        this.systemMenuMapper.insert(dbInsert);
    }

    public void deleteData(String menuId) {
        this.systemMenuMapper.deleteById((Serializable)((Object)menuId));
    }

    public MenuEntity getMenuById(String menuId) {
        SystemMenuDO dbResult = (SystemMenuDO)this.systemMenuMapper.selectById((Serializable)((Object)menuId));
        MenuEntity result = new MenuEntity();
        result.setParentMenuId(dbResult.getParentMenuId());
        result.setMenuUrl(dbResult.getMenuUrl());
        result.setMenuName(dbResult.getMenuName());
        result.setMenuIcon(dbResult.getMenuIcon());
        result.setMenuPermission(dbResult.getMenuPermission());
        result.setParentMenuId(dbResult.getParentMenuId());
        result.setMenuId(dbResult.getMenuId());
        return result;
    }

    public void modifyData(MenuEntity menuEntity) {
        SystemMenuDO dbModify = new SystemMenuDO();
        dbModify.setMenuId(menuEntity.getMenuId());
        dbModify.setMenuName(menuEntity.getMenuName());
        dbModify.setMenuPermission(menuEntity.getMenuPermission());
        dbModify.setMenuUrl(menuEntity.getMenuUrl());
        dbModify.setMenuIcon(menuEntity.getMenuIcon());
        this.systemMenuMapper.updateById(dbModify);
    }
}

