/*
 * Decompiled with CFR 0.152.
 */
package org.huiche.data.query;

import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.QBean;
import com.querydsl.sql.RelationalPath;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.huiche.core.util.HuiCheUtil;
import org.huiche.data.entity.BaseEntity;
import org.jetbrains.annotations.Contract;

public interface Query {
    @Nullable
    default public Predicate predicate(boolean ok, @Nonnull Supplier<Predicate> predicate) {
        if (ok) {
            return predicate.get();
        }
        return null;
    }

    @Nullable
    @Contract(value="null, _ -> null")
    default public <T> Predicate predicate(@Nullable T val, @Nonnull Function<T, Predicate> op) {
        return this.predicate((T)HuiCheUtil.isNotEmpty(val), () -> (Predicate)op.apply(val));
    }

    @Nullable
    @Contract(value="null, _ -> null")
    default public <T> Predicate predicate(@Nullable T val, @Nonnull Supplier<Predicate> predicate) {
        if (HuiCheUtil.isNotEmpty(val)) {
            return predicate.get();
        }
        return null;
    }

    @Nullable
    default public <T> Predicate predicate(@Nonnull Supplier<Predicate> predicate) {
        return predicate.get();
    }

    @Nullable
    default public Predicate predicates(Predicate ... predicate) {
        return ExpressionUtils.allOf((Predicate[])predicate);
    }

    @Nullable
    default public Predicate and(Predicate ... predicate) {
        return ExpressionUtils.allOf((Predicate[])predicate);
    }

    @Nullable
    default public Predicate or(Predicate ... predicate) {
        return ExpressionUtils.anyOf((Predicate[])predicate);
    }

    @Nonnull
    public static <T extends BaseEntity<T>> Expression[] extendColumn(@Nonnull RelationalPath<T> beanPath, Expression ... columns) {
        ArrayList<Expression> list = new ArrayList<Expression>();
        list.addAll(beanPath.getColumns());
        list.addAll(Arrays.asList(columns));
        return list.toArray(new Expression[0]);
    }

    @Nonnull
    public static <T extends BaseEntity<T>> Expression[] excludeColumn(@Nonnull RelationalPath<T> beanPath, Expression ... columns) {
        List pathColumns = beanPath.getColumns();
        if (columns.length > 0) {
            List<Expression> excludeList = Arrays.asList(columns);
            pathColumns.removeIf(excludeList::contains);
        }
        return pathColumns.toArray(new Expression[0]);
    }

    @Nonnull
    public static <DTO extends T, T extends BaseEntity<T>> QBean<DTO> extendBean(@Nonnull Class<DTO> dtoClass, @Nonnull RelationalPath<T> beanPath, Expression ... columns) {
        return Projections.fields(dtoClass, (Expression[])Query.extendColumn(beanPath, columns));
    }
}

