/*
 * Decompiled with CFR 0.152.
 */
package org.huiche.data.page;

import java.io.Serializable;
import org.huiche.core.util.HuiCheUtil;

public class PageRequest
implements Serializable {
    private int page = 1;
    private int rows = 10;
    private String sort;
    private String order;

    public PageRequest() {
    }

    public PageRequest(Integer page) {
        this.page = null == page ? 1 : page;
    }

    public PageRequest(Integer page, Integer rows) {
        this.page = null == page ? 1 : page;
        this.rows = null == rows ? 10 : rows;
    }

    public PageRequest(Integer page, Integer rows, String sort, String order) {
        this.page = null == page ? 1 : page;
        int n = this.rows = null == rows ? 10 : rows;
        if (HuiCheUtil.isNotEmpty((CharSequence)sort)) {
            this.sort = sort;
        }
        if (HuiCheUtil.isNotEmpty((CharSequence)order)) {
            this.order = order;
        }
    }

    public long getOffset() {
        return (this.page - 1) * this.rows;
    }

    public PageRequest setPage(Integer page) {
        this.page = null == page ? 1 : page;
        return this;
    }

    public PageRequest setRows(Integer rows) {
        this.rows = null == rows ? 10 : rows;
        return this;
    }

    public PageRequest setSort(String sort) {
        if (HuiCheUtil.isNotEmpty((CharSequence)sort)) {
            this.sort = sort;
        }
        return this;
    }

    public PageRequest setOrder(String order) {
        if (HuiCheUtil.isNotEmpty((CharSequence)order)) {
            this.order = order;
        }
        return this;
    }

    public int getPage() {
        return this.page;
    }

    public int getRows() {
        return this.rows;
    }

    public String getSort() {
        return this.sort;
    }

    public String getOrder() {
        return this.order;
    }

    public String toString() {
        return "PageRequest(page=" + this.getPage() + ", rows=" + this.getRows() + ", sort=" + this.getSort() + ", order=" + this.getOrder() + ")";
    }
}

