/*
 * Decompiled with CFR 0.152.
 */
package org.huiche.dao.support;

import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.QBean;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.StringExpression;
import com.querydsl.sql.RelationalPath;
import java.lang.reflect.Field;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.huiche.support.ReflectUtil;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

public interface Querys {
    public static Expression<?>[] columns(Expression<?> ... cols) {
        return cols;
    }

    public static OrderSpecifier<?>[] orders(OrderSpecifier<?> ... orders) {
        return orders;
    }

    public static <T> Predicate[] ofEntity(T entity4Query, RelationalPath<T> table) {
        ArrayList<BooleanExpression> pds = new ArrayList<BooleanExpression>();
        try {
            Map columnsMap = table.getColumns().stream().collect(Collectors.toMap(t -> t.getMetadata().getName(), Function.identity()));
            for (Field field : ReflectUtil.scanNormalFields(entity4Query.getClass())) {
                try {
                    field.setAccessible(true);
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
                Object val = field.get(entity4Query);
                String fieldName = field.getName();
                if (val == null || !columnsMap.containsKey(fieldName)) continue;
                String sv = String.valueOf(val);
                if (val instanceof CharSequence) {
                    pds.add(Expressions.stringPath(table, (String)fieldName).contains(sv));
                    continue;
                }
                if (val instanceof Number) {
                    pds.add(Expressions.numberPath(Double.class, table, (String)fieldName).eq((Object)Double.valueOf(sv)));
                    continue;
                }
                if (val instanceof Boolean) {
                    pds.add(Expressions.booleanPath(table, (String)fieldName).eq(Boolean.valueOf(sv)));
                    continue;
                }
                if (!field.getType().isEnum() && !(val instanceof Date) && !(val instanceof LocalDate) && !(val instanceof LocalTime) && !(val instanceof LocalDateTime) && !(val instanceof OffsetTime) && !(val instanceof OffsetDateTime) && !(val instanceof ZonedDateTime)) continue;
                pds.add(Expressions.stringPath(table, (String)fieldName).eq((Object)sv));
            }
            return pds.toArray(new Predicate[0]);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    @Nullable
    public static Predicate predicate(boolean ok, @NonNull Supplier<Predicate> predicate) {
        if (ok) {
            return predicate.get();
        }
        return null;
    }

    @Nullable
    public static <T> Predicate predicate(@Nullable T val, @NonNull Function<T, Predicate> op) {
        return Querys.predicate(val != null, () -> (Predicate)op.apply(val));
    }

    @Nullable
    public static <T> Predicate predicate(@Nullable T val, @NonNull Supplier<Predicate> predicate) {
        if (val != null) {
            return predicate.get();
        }
        return null;
    }

    @Nullable
    public static <T> Predicate predicate(@NonNull Supplier<Predicate> predicate) {
        return predicate.get();
    }

    @Nullable
    public static Predicate keyword(@Nullable String keyword, StringExpression ... cols) {
        if (keyword == null || cols.length == 0) {
            return null;
        }
        if ((keyword = keyword.trim()).length() == 0) {
            return null;
        }
        ArrayList<BooleanExpression> list = new ArrayList<BooleanExpression>(cols.length);
        for (StringExpression col : cols) {
            list.add(col.contains(keyword));
        }
        return ExpressionUtils.anyOf(list);
    }

    @Nullable
    public static Predicate keywordSplit(@Nullable String keyword, @NonNull String separator, StringExpression ... cols) {
        if (keyword == null || keyword.trim().length() == 0 || cols.length == 0) {
            return null;
        }
        String[] keywords = keyword.split(separator);
        if (keywords.length == 0) {
            return null;
        }
        ArrayList<BooleanExpression> list = new ArrayList<BooleanExpression>(cols.length);
        for (StringExpression col : cols) {
            for (String word : keywords) {
                if ((word = word.trim()).length() <= 0) continue;
                list.add(col.contains(word));
            }
        }
        return ExpressionUtils.anyOf(list);
    }

    @Nullable
    public static Predicate keywordSplit(@Nullable String keyword, StringExpression ... cols) {
        return Querys.keywordSplit(keyword, " ", cols);
    }

    @Nullable
    public static Predicate and(Predicate ... conditions) {
        return ExpressionUtils.allOf((Predicate[])conditions);
    }

    @NonNull
    public static Predicate[] concat(@Nullable Predicate predicate, @NonNull Predicate[] predicates) {
        if (predicate != null) {
            ArrayList<Predicate> list = new ArrayList<Predicate>();
            list.add(predicate);
            list.addAll(Arrays.asList(predicates));
            return list.toArray(new Predicate[0]);
        }
        return predicates;
    }

    @NonNull
    public static Predicate[] concat(@NonNull Predicate[] predicates1, Predicate ... predicates2) {
        if (predicates1.length == 0) {
            return predicates2;
        }
        if (predicates2.length == 0) {
            return predicates1;
        }
        ArrayList<Predicate> list = new ArrayList<Predicate>(Arrays.asList(predicates1));
        list.addAll(Arrays.asList(predicates2));
        return list.toArray(new Predicate[0]);
    }

    @Nullable
    public static Predicate or(Predicate ... predicate) {
        return ExpressionUtils.anyOf((Predicate[])predicate);
    }

    @NonNull
    public static <T> Expression<?>[] extendColumn(@NonNull RelationalPath<T> beanPath, Expression<?> ... columns) {
        ArrayList list = new ArrayList();
        list.addAll(beanPath.getColumns());
        list.addAll(Arrays.asList(columns));
        return list.toArray(new Expression[0]);
    }

    @NonNull
    public static <T> Expression<?>[] excludeColumn(@NonNull RelationalPath<T> beanPath, Expression<?> ... columns) {
        List pathColumns = beanPath.getColumns();
        if (columns.length > 0) {
            List<Expression<?>> excludeList = Arrays.asList(columns);
            pathColumns.removeIf(excludeList::contains);
        }
        return pathColumns.toArray(new Expression[0]);
    }

    @NonNull
    public static <DTO extends T, T> QBean<DTO> extendBean(@NonNull Class<DTO> dtoClass, @NonNull RelationalPath<T> beanPath, Expression<?> ... columns) {
        return Projections.fields(dtoClass, Querys.extendColumn(beanPath, columns));
    }
}

