/*
 * Decompiled with CFR 0.152.
 */
package org.huiche.dao.support;

import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.SQLQuery;
import java.util.ArrayList;
import java.util.List;
import org.huiche.dao.support.Search;
import org.huiche.domain.PageRequest;
import org.huiche.domain.Pageable;
import org.springframework.lang.NonNull;

public class Query {
    private final List<Predicate> wheres = new ArrayList<Predicate>();
    private final List<OrderSpecifier<?>> orders = new ArrayList();
    private Long page;
    private Long size;

    public static Query of() {
        return new Query();
    }

    public static Query of(Long page, Long size) {
        return new Query().page(page, size);
    }

    public Query page(Long page, Long size) {
        this.page = page;
        this.size = size;
        return this;
    }

    public static Query of(Pageable pageable) {
        return new Query().page(pageable);
    }

    public Query page(@NonNull Pageable pageable) {
        this.page = pageable.page();
        this.size = pageable.size();
        return this;
    }

    public static Query of(Predicate ... wheres) {
        return new Query().where(wheres);
    }

    public static Query of(Search search) {
        return new Query().where(search.get());
    }

    public Query where(Predicate ... wheres) {
        for (Predicate where : wheres) {
            if (where == null) continue;
            this.wheres.add(where);
        }
        return this;
    }

    public Query where(@NonNull Search search) {
        return this.where(search.get());
    }

    public static Query of(OrderSpecifier<?> ... orders) {
        return new Query().order(orders);
    }

    public Query order(OrderSpecifier<?> ... orders) {
        for (OrderSpecifier<?> order : orders) {
            if (order == null) continue;
            this.orders.add(order);
        }
        return this;
    }

    public Query size(Long size) {
        this.size = size;
        return this;
    }

    public <T> SQLQuery<T> useForPage(SQLQuery<T> query) {
        this.use(query);
        if (this.size == null) {
            query.limit(10L);
        }
        return query;
    }

    public <T> SQLQuery<T> use(SQLQuery<T> query) {
        if (!this.wheres.isEmpty()) {
            query.where(this.wheres.toArray(new Predicate[0]));
        }
        if (!this.orders.isEmpty()) {
            query.orderBy(this.orders.toArray(new OrderSpecifier[0]));
        }
        if (this.page != null && this.size != null) {
            query.offset(this.size * (this.page - 1L));
        }
        if (this.size != null) {
            query.limit(this.size.longValue());
        }
        return query;
    }

    public Pageable getPageable() {
        PageRequest pageable = new PageRequest();
        pageable.setPage(Long.valueOf(this.page == null ? 1L : this.page));
        pageable.setSize(Long.valueOf(this.size == null ? 10L : this.size));
        return pageable;
    }
}

