/*
 * Decompiled with CFR 0.152.
 */
package org.huiche.dao.support;

import com.querydsl.core.QueryResults;
import com.querydsl.core.Tuple;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.huiche.domain.Page;
import org.huiche.domain.Pageable;

public class PageImpl<T>
implements Page<T> {
    private Long page;
    private Long size;
    private Long total;
    private List<T> content;

    public static <T> Page<T> of(Long page, Long size, Long totalItem, List<T> rows) {
        PageImpl<T> impl = new PageImpl<T>();
        impl.page = page == null ? 1L : page;
        impl.size = size == null ? 10L : size;
        impl.total = totalItem == null ? 0L : totalItem;
        impl.content = rows;
        return impl;
    }

    public static <T> Page<T> of(Pageable pageable, QueryResults<T> result) {
        PageImpl<T> impl = new PageImpl<T>();
        impl.page = pageable.page();
        impl.size = pageable.size();
        impl.total = result.getTotal();
        impl.content = result.getResults();
        return impl;
    }

    public static <T> Page<T> of(Pageable pageable, QueryResults<Tuple> result, Function<Tuple, T> mapper) {
        PageImpl<T> impl = new PageImpl<T>();
        impl.page = pageable.page();
        impl.size = pageable.size();
        impl.total = result.getTotal();
        impl.content = result.getResults().stream().map(mapper).collect(Collectors.toList());
        return impl;
    }

    public static <T, R> Page<R> of(Page<T> page, Function<T, R> mapper) {
        PageImpl<T> impl = new PageImpl<T>();
        impl.page = page.getPage();
        impl.size = page.getSize();
        impl.total = page.getTotal();
        impl.content = page.getContent().stream().map(mapper).collect(Collectors.toList());
        return impl;
    }

    public long getPage() {
        return this.page;
    }

    public long getSize() {
        return this.size;
    }

    public long getTotal() {
        return this.total;
    }

    public List<T> getContent() {
        return this.content;
    }

    public String toString() {
        return "PageImpl{page=" + this.page + ", size=" + this.size + ", total=" + this.total + ", content=" + this.content + '}';
    }
}

