/*
 * Decompiled with CFR 0.152.
 */
package org.huiche.dao.operation;

import com.querydsl.core.types.Predicate;
import com.querydsl.sql.dml.SQLUpdateClause;
import java.io.Serializable;
import java.util.function.Consumer;
import org.springframework.jdbc.JdbcUpdateAffectedIncorrectNumberOfRowsException;
import org.springframework.lang.Nullable;

public interface UpdateOperation<T> {
    default public <ID extends Serializable> long updateById(T entityUpdate, ID id) {
        return this.updateById(entityUpdate, null, id);
    }

    public <ID extends Serializable> long updateById(@Nullable T var1, @Nullable Consumer<SQLUpdateClause> var2, ID var3);

    default public <ID extends Serializable> long updateById(Consumer<SQLUpdateClause> setter, ID id) {
        return this.updateById(null, setter, id);
    }

    default public long update(T entityUpdate, Predicate ... conditions) {
        return this.update(entityUpdate, (Consumer<SQLUpdateClause>)null, conditions);
    }

    public long update(@Nullable T var1, @Nullable Consumer<SQLUpdateClause> var2, Predicate ... var3);

    default public long update(Consumer<SQLUpdateClause> setter, Predicate ... conditions) {
        return this.update(null, setter, conditions);
    }

    default public void updateOneRow(@Nullable T entityUpdate, @Nullable Consumer<SQLUpdateClause> setter, Predicate ... conditions) {
        long updateCount = this.update(entityUpdate, setter, conditions);
        if (updateCount != 1L) {
            throw new JdbcUpdateAffectedIncorrectNumberOfRowsException("huiche-dao-update", 1, (int)updateCount);
        }
    }

    default public void updateOneRow(T entityUpdate, Predicate ... conditions) {
        this.updateOneRow(entityUpdate, (Consumer<SQLUpdateClause>)null, conditions);
    }

    default public void updateOneRow(Consumer<SQLUpdateClause> setter, Predicate ... conditions) {
        this.updateOneRow(null, setter, conditions);
    }
}

