/*
 * Decompiled with CFR 0.152.
 */
package org.huiche.dao;

import com.querydsl.core.types.Path;
import com.querydsl.core.types.PathMetadata;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.StringPath;
import com.querydsl.core.util.ReflectionUtils;
import com.querydsl.sql.RelationalPath;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.stream.Collectors;
import org.huiche.annotation.Column;
import org.huiche.support.IdGenerator;
import org.huiche.support.PrimaryKey;
import org.springframework.dao.TypeMismatchDataAccessException;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

public class IdInfo {
    private final String name;
    private final StringPath wherePath;
    private final Path<?> path;
    private final Class<?> type;
    private final PrimaryKey idType;
    private final Field field;
    private final IdGenerator idGenerator;

    IdInfo(RelationalPath<?> table, Path<?> column) {
        PathMetadata metadata = column.getMetadata();
        this.name = metadata.getName();
        this.path = column;
        this.wherePath = Expressions.stringPath((Path)metadata.getParent(), (String)this.name);
        this.type = column.getType();
        Field field = ReflectionUtils.getFieldOrNull((Class)table.getType(), (String)this.name);
        if (field == null) {
            throw new TypeMismatchDataAccessException("can not find field: " + this.name + " in " + this.type.getCanonicalName());
        }
        this.field = field;
        try {
            this.field.setAccessible(true);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        Column colAnno = column.getAnnotatedElement().getAnnotation(Column.class);
        if (colAnno == null || PrimaryKey.NOT_PK.equals((Object)colAnno.primaryKey())) {
            throw new TypeMismatchDataAccessException(this.type.getCanonicalName() + "#" + this.name + "is not a pk,you need add a @Column and set isPrimaryKey=true");
        }
        this.idType = colAnno.primaryKey();
        if (PrimaryKey.GENERATE.equals((Object)this.idType)) {
            if (colAnno.idGenerator() == IdGenerator.class) {
                this.idGenerator = IdGenerator.DEFAULT;
            } else {
                try {
                    this.idGenerator = (IdGenerator)colAnno.idGenerator().getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Exception e) {
                    throw new RuntimeException("can not load idGenerator: " + colAnno.idGenerator().getCanonicalName(), e);
                }
            }
        } else {
            this.idGenerator = null;
        }
    }

    public String toString() {
        return "IdInfo{name='" + this.name + '\'' + ", wherePath=" + this.wherePath + ", path=" + this.path + ", type=" + this.type + ", idType=" + this.idType + ", field=" + this.field + ", idGenerator=" + this.idGenerator + '}';
    }

    public <ID> Predicate idWhere(ID id) {
        return this.wherePath.eq((Object)String.valueOf(id));
    }

    public <ID> Predicate idsWhere(@NonNull Collection<ID> ids) {
        return this.wherePath.in((Collection)ids.stream().map(String::valueOf).collect(Collectors.toList()));
    }

    public Path<?> getPath() {
        return this.path;
    }

    public boolean isAutoIncrement() {
        return PrimaryKey.AUTO.equals((Object)this.idType);
    }

    public void setIdVal(Object entity, @Nullable Object val) {
        try {
            this.field.set(entity, val);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    @NonNull
    Object generateId() {
        if (Number.class.isAssignableFrom(this.type)) {
            return this.idGenerator.generateNumberId();
        }
        if (CharSequence.class.isAssignableFrom(this.type)) {
            return this.idGenerator.generateStrId();
        }
        throw new RuntimeException("not support type:" + this.type.getCanonicalName() + " generate id");
    }

    @Nullable
    public Object getIdVal(Object entity) {
        try {
            return this.field.get(entity);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean handleId(Object entity) {
        try {
            Object val = this.field.get(entity);
            if (val == null) {
                switch (this.idType) {
                    case AUTO: {
                        return true;
                    }
                    case GENERATE: {
                        this.field.set(entity, this.generateId());
                        break;
                    }
                    default: {
                        throw new RuntimeException("this operation need primary key:" + this.name + " has a value");
                    }
                }
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        return false;
    }
}

