/*
 * Decompiled with CFR 0.152.
 */
package org.huiche.dao;

import com.querydsl.core.QueryFlag;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQueryFactory;
import com.querydsl.sql.dml.DefaultMapper;
import com.querydsl.sql.dml.Mapper;
import com.querydsl.sql.dml.SQLInsertClause;
import com.querydsl.sql.dml.SQLUpdateClause;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import org.huiche.dao.AbstractCrudDao;
import org.huiche.dao.IdInfo;
import org.huiche.dao.support.Query;
import org.huiche.dao.support.Querys;
import org.huiche.exception.HuicheIllegalArgumentException;
import org.springframework.lang.Nullable;

public class CrudDaoSinglePkImpl<T>
extends AbstractCrudDao<T> {
    protected final IdInfo idInfo;

    CrudDaoSinglePkImpl(SQLQueryFactory sql, RelationalPath<T> table, IdInfo idInfo) {
        this.sql = sql;
        this.table = table;
        this.idInfo = idInfo;
    }

    @Override
    public <ID extends Serializable> boolean existsById(ID id) {
        return this.exists(this.idInfo.idWhere(id));
    }

    @Override
    @Nullable
    public <ID extends Serializable> T getById(ID id, Predicate ... conditions) {
        return this.getOne(Querys.concat(this.idInfo.idWhere(id), conditions));
    }

    @Override
    @Nullable
    public <ID extends Serializable, Col> Col getColumnById(Expression<Col> column, ID id, Predicate ... conditions) {
        return this.getColumnOne(column, Querys.concat(this.idInfo.idWhere(id), conditions));
    }

    @Override
    @Nullable
    public <ID extends Serializable> T getColumnsById(Expression<?>[] columns, ID id, Predicate ... conditions) {
        return this.getColumnsOne(columns, Querys.concat(this.idInfo.idWhere(id), conditions));
    }

    @Override
    @Nullable
    public <ID extends Serializable, DTO> DTO getDtoById(Class<DTO> dtoClass, Expression<?>[] columns, ID id, Predicate ... conditions) {
        return this.getDtoOne(dtoClass, columns, Querys.concat(this.idInfo.idWhere(id), conditions));
    }

    @Override
    public <ID extends Serializable> List<T> listByIds(Collection<ID> ids) {
        return this.list(Query.of(this.idInfo.idsWhere(ids)));
    }

    @Override
    public <ID extends Serializable> List<T> listColumnsByIds(Expression<?>[] columns, Collection<ID> ids) {
        return this.listColumns(columns, this.idInfo.idsWhere(ids));
    }

    @Override
    public <ID extends Serializable, Col> List<Col> listColumnByIds(Path<Col> column, Collection<ID> ids) {
        return this.listColumn(column, this.idInfo.idsWhere(ids));
    }

    @Override
    public <ID extends Serializable, DTO> List<DTO> listDtoByIds(Class<DTO> dtoClass, Expression<?>[] columns, Collection<ID> ids) {
        return this.listDto(dtoClass, columns, this.idInfo.idsWhere(ids));
    }

    @Override
    public <ID extends Serializable> long deleteById(ID id) {
        return this.delete(this.idInfo.idWhere(id));
    }

    @Override
    public <ID extends Serializable> long deleteByIds(Collection<ID> ids) {
        return this.delete(this.idInfo.idsWhere(ids));
    }

    @Override
    public <ID extends Serializable> long updateById(@Nullable T entityUpdate, @Nullable Consumer<SQLUpdateClause> setter, ID id) {
        return this.update(entityUpdate, setter, this.idInfo.idWhere(id));
    }

    @Override
    public <E extends T> E create(E entity) {
        this.beforeCreate(entity);
        SQLInsertClause dml = this.sql.insert(this.table);
        boolean autoIncrement = this.idInfo.handleId(entity);
        dml.populate(entity);
        if (autoIncrement) {
            this.idInfo.setIdVal(entity, dml.executeWithKey(this.idInfo.getPath()));
        } else {
            dml.execute();
        }
        return entity;
    }

    @Override
    public <E extends T> E replace(E entity) {
        this.beforeCreate(entity);
        if (this.idInfo.getIdVal(entity) == null) {
            throw new HuicheIllegalArgumentException("replace operation need primary key has a value");
        }
        ((SQLInsertClause)((SQLInsertClause)this.sql.insert(this.table).addFlag(QueryFlag.Position.START_OVERRIDE, "REPLACE INTO ")).populate(entity)).execute();
        return entity;
    }

    @Override
    public <E extends T> E save(E entity) {
        Object val = this.idInfo.getIdVal(entity);
        if (val == null) {
            return this.create(entity);
        }
        this.update(entity, this.idInfo.idWhere(val));
        return entity;
    }

    @Override
    public <E extends T> long createBatch(Collection<E> entityList) {
        SQLInsertClause dmlHasId = this.sql.insert(this.table);
        SQLInsertClause dmlHasNoId = this.sql.insert(this.table);
        ArrayList<E> hasNoIdList = new ArrayList<E>(entityList.size());
        for (E entity : entityList) {
            this.beforeCreate(entity);
            if (this.idInfo.handleId(entity)) {
                ((SQLInsertClause)dmlHasNoId.populate(entity, (Mapper)DefaultMapper.WITH_NULL_BINDINGS)).addBatch();
                hasNoIdList.add(entity);
                continue;
            }
            ((SQLInsertClause)dmlHasId.populate(entity, (Mapper)DefaultMapper.WITH_NULL_BINDINGS)).addBatch();
        }
        long result = 0L;
        if (this.idInfo.isAutoIncrement() && !dmlHasNoId.isEmpty()) {
            result += this.autoIncrementIdsExecuteAndSet(dmlHasNoId, this.idInfo, hasNoIdList);
        }
        if (!dmlHasId.isEmpty()) {
            result += dmlHasId.execute();
        }
        return result;
    }
}

