/*
 * Decompiled with CFR 0.152.
 */
package org.huiche.dao;

import com.querydsl.core.QueryFlag;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQueryFactory;
import com.querydsl.sql.dml.DefaultMapper;
import com.querydsl.sql.dml.Mapper;
import com.querydsl.sql.dml.SQLInsertClause;
import com.querydsl.sql.dml.SQLUpdateClause;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import org.huiche.dao.AbstractCrudDao;
import org.huiche.dao.IdInfo;
import org.huiche.exception.HuicheIllegalArgumentException;
import org.springframework.dao.TypeMismatchDataAccessException;
import org.springframework.lang.Nullable;

public class CrudDaoMultiplePkImpl<T>
extends AbstractCrudDao<T> {
    private static final RuntimeException EXCEPTION = new TypeMismatchDataAccessException("this operation need table has one and only primary key");
    private final IdInfo autoIncrementId;
    private final List<IdInfo> otherIdInfoList = new ArrayList<IdInfo>();
    private final RelationalPath<T> table;

    CrudDaoMultiplePkImpl(SQLQueryFactory sql, RelationalPath<T> table, List<IdInfo> idInfoList) {
        this.sql = sql;
        this.table = table;
        IdInfo autoId = null;
        for (IdInfo idInfo : idInfoList) {
            if (idInfo.isAutoIncrement()) {
                if (autoId == null) {
                    autoId = idInfo;
                    continue;
                }
                throw EXCEPTION;
            }
            this.otherIdInfoList.add(idInfo);
        }
        this.autoIncrementId = autoId;
    }

    @Override
    public <ID extends Serializable> boolean existsById(ID id) {
        throw EXCEPTION;
    }

    @Override
    public <E extends T> E create(E entity) {
        this.beforeCreate(entity);
        SQLInsertClause dml = this.sql.insert(this.table);
        boolean autoIncrement = this.autoIncrementId != null && this.autoIncrementId.handleId(entity);
        this.otherIdInfoList.forEach(id -> id.handleId(entity));
        dml.populate(entity);
        if (autoIncrement) {
            this.autoIncrementId.setIdVal(entity, dml.executeWithKey(this.autoIncrementId.getPath()));
        } else {
            dml.execute();
        }
        return entity;
    }

    @Override
    public <ID extends Serializable> T getById(ID id, Predicate ... conditions) {
        throw EXCEPTION;
    }

    @Override
    public <E extends T> E replace(E entity) {
        this.beforeCreate(entity);
        if (this.autoIncrementId != null && this.autoIncrementId.getIdVal(entity) == null) {
            throw new HuicheIllegalArgumentException("replace operation need primary key has a value");
        }
        this.otherIdInfoList.forEach(id -> id.handleId(entity));
        ((SQLInsertClause)((SQLInsertClause)this.sql.insert(this.table).addFlag(QueryFlag.Position.START_OVERRIDE, "REPLACE INTO ")).populate(entity)).execute();
        return entity;
    }

    @Override
    public <ID extends Serializable, Col> Col getColumnById(Expression<Col> column, ID id, Predicate ... conditions) {
        throw EXCEPTION;
    }

    @Override
    public <E extends T> E save(E entity) {
        boolean isUpdate = true;
        ArrayList<Predicate> idWhere = new ArrayList<Predicate>();
        if (this.autoIncrementId != null) {
            Object val = this.autoIncrementId.getIdVal(entity);
            if (val == null) {
                isUpdate = false;
            } else {
                idWhere.add(this.autoIncrementId.idWhere(val));
            }
        }
        for (IdInfo idInfo : this.otherIdInfoList) {
            Object val = idInfo.getIdVal(entity);
            if (val == null) {
                isUpdate = false;
                break;
            }
            idWhere.add(idInfo.idWhere(val));
        }
        if (isUpdate) {
            this.update(entity, idWhere.toArray(new Predicate[0]));
            return entity;
        }
        return this.create(entity);
    }

    @Override
    public <ID extends Serializable> T getColumnsById(Expression<?>[] columns, ID id, Predicate ... conditions) {
        throw EXCEPTION;
    }

    @Override
    public <E extends T> long createBatch(Collection<E> entityList) {
        SQLInsertClause dmlHasNoId = this.sql.insert(this.table);
        SQLInsertClause dmlHasId = this.sql.insert(this.table);
        ArrayList<E> hasNoIdList = new ArrayList<E>(entityList.size());
        for (Object entity : entityList) {
            this.beforeCreate(entity);
            if (this.autoIncrementId != null && this.autoIncrementId.getIdVal(entity) == null) {
                ((SQLInsertClause)dmlHasNoId.populate(entity, (Mapper)DefaultMapper.WITH_NULL_BINDINGS)).addBatch();
                hasNoIdList.add(entity);
                continue;
            }
            this.otherIdInfoList.forEach(id -> id.handleId(entity));
            ((SQLInsertClause)dmlHasId.populate(entity, (Mapper)DefaultMapper.WITH_NULL_BINDINGS)).addBatch();
        }
        long result = 0L;
        if (this.autoIncrementId != null && !dmlHasNoId.isEmpty()) {
            result += this.autoIncrementIdsExecuteAndSet(dmlHasNoId, this.autoIncrementId, hasNoIdList);
        }
        if (!dmlHasId.isEmpty()) {
            result += dmlHasId.execute();
        }
        return result;
    }

    @Override
    public <ID extends Serializable, DTO> DTO getDtoById(Class<DTO> dtoClass, Expression<?>[] columns, ID id, Predicate ... conditions) {
        throw EXCEPTION;
    }

    @Override
    public <ID extends Serializable> List<T> listByIds(Collection<ID> ids) {
        throw EXCEPTION;
    }

    @Override
    public <ID extends Serializable> List<T> listColumnsByIds(Expression<?>[] columns, Collection<ID> ids) {
        throw EXCEPTION;
    }

    @Override
    public <ID extends Serializable, Col> List<Col> listColumnByIds(Path<Col> column, Collection<ID> ids) {
        throw EXCEPTION;
    }

    @Override
    public <ID extends Serializable, DTO> List<DTO> listDtoByIds(Class<DTO> dtoClass, Expression<?>[] columns, Collection<ID> ids) {
        throw EXCEPTION;
    }

    @Override
    public <ID extends Serializable> long deleteById(ID id) {
        throw EXCEPTION;
    }

    @Override
    public <ID extends Serializable> long deleteByIds(Collection<ID> ids) {
        throw EXCEPTION;
    }

    @Override
    public <ID extends Serializable> long updateById(@Nullable T entityUpdate, @Nullable Consumer<SQLUpdateClause> setter, ID id) {
        throw EXCEPTION;
    }
}

