/*
 * Decompiled with CFR 0.152.
 */
package org.huiche.dao;

import com.querydsl.core.types.Path;
import com.querydsl.sql.PrimaryKey;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQueryFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.huiche.dao.CrudDaoMultiplePkImpl;
import org.huiche.dao.CrudDaoNonePkImpl;
import org.huiche.dao.CrudDaoSinglePkImpl;
import org.huiche.dao.IdInfo;
import org.huiche.dao.operation.CrudOperation;

public class CrudDaoFactory {
    public static <T> CrudOperation<T> create(SQLQueryFactory sql, RelationalPath<T> table) {
        List<IdInfo> ids = CrudDaoFactory.getIdListByTable(table);
        int size = ids.size();
        if (size == 0) {
            return new CrudDaoNonePkImpl<T>(sql, table);
        }
        if (size == 1) {
            return new CrudDaoSinglePkImpl<T>(sql, table, ids.get(0));
        }
        return new CrudDaoMultiplePkImpl<T>(sql, table, ids);
    }

    public static <T> List<IdInfo> getIdListByTable(RelationalPath<T> table) {
        List ids;
        int size;
        PrimaryKey pk = table.getPrimaryKey();
        if (pk != null && (size = (ids = pk.getLocalColumns()).size()) > 0) {
            ArrayList<IdInfo> list = new ArrayList<IdInfo>(size);
            for (Path id : ids) {
                list.add(new IdInfo(table, id));
            }
            return list;
        }
        return Collections.emptyList();
    }
}

